import { Injectable } from '@nestjs/common';
import { IpregModuleOptions } from '@yandex-id/ipreg';

import { EnvConfig, getEnvConfig } from '../env-config';

const config: EnvConfig<IpregModuleOptions> = {
  development: {
    disabled: true,
  },
  testing: {
    dbPath: '/usr/lib/yandex/id-frontend/ipreg-base.json',
  },
  production: {
    dbPath: '/usr/lib/yandex/id-frontend/ipreg-base.json',
  },
};

@Injectable()
export class IpregConfigService {
  getOptions(): IpregModuleOptions {
    return getEnvConfig(config);
  }
}
