import { Injectable } from '@nestjs/common';
import { LogLevel } from '@yandex-int/yandex-logger';

import { EnvConfig, getEnvConfig } from '../env-config';

interface LoggerOptions {
  logType: 'deploy' | 'strLine';
  logLevel: LogLevel;
}

const config: EnvConfig<LoggerOptions> = {
  common: {
    logLevel: (process.env.LOGLEVEL as LogLevel) || 'warn',
    logType: process.env.DEPLOY_PROJECT_ID ? 'deploy' : 'strLine',
  },
  testing: {
    logLevel: 'debug',
  },
  production: {
    logLevel: 'debug',
  },
};

@Injectable()
export class LoggerConfigService {
  get options(): LoggerOptions {
    return getEnvConfig(config);
  }
}
