import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface OhioOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<OhioOptions> = {
  common: {
    url: 'https://ohio-backend-test.so.yandex.net',
    timeout: 4500,
  },
  rc: {
    url: 'https://ohio-backend-rc.so.yandex.net',
  },
  production: {
    url: 'https://ohio-backend.so.yandex.net',
  },
};

@Injectable()
export class OhioConfigService {
  get options(): OhioOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
      paramsSerializer: (params = {}) => {
        return Object.entries(params)
          .reduce<string[]>((aux, entry) => {
            const [key, value] = entry;

            if (value !== null && value !== undefined) {
              if (Array.isArray(value)) {
                value.forEach((item) => {
                  aux.push(`${key}=${encodeURIComponent(String(item))}`);
                });

                return aux;
              }

              aux.push(`${key}=${encodeURIComponent(String(value))}`);
            }

            return aux;
          }, [])
          .join('&');
      },
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'ohio',
      useUserTicket: true,
    };
  }
}
