import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface PassportOptions {
  host: string;
  url: string;
  hostHeader: string;
}

const config: EnvConfig<PassportOptions> = {
  development: {
    host: 'passport-test.yandex.{tld}',
    url: 'http://127.0.0.1:8080',
    hostHeader: 'passport-test-internal.yandex.ru',
  },
  testing: {
    host: 'passport-test.yandex.{tld}',
    url: process.env.PASSPORT_API_URL || 'http://passport-test-internal.yandex.ru',
    hostHeader: 'passport-test-internal.yandex.ru',
  },
  stress: {
    host: 'passport-load.yandex.{tld}',
    url: process.env.PASSPORT_API_URL || 'http://passport-load-internal.yandex.ru',
    hostHeader: 'passport-load-internal.yandex.ru',
  },
  rc: {
    host: 'passport.yandex.{tld}',
    url: 'http://passport-internal.yandex.ru',
    hostHeader: 'passport-internal.yandex.ru',
  },
  production: {
    host: 'passport.yandex.{tld}',
    url: process.env.PASSPORT_API_URL || 'http://passport-internal.yandex.ru',
    hostHeader: 'passport-internal.yandex.ru',
  },
};

@Injectable()
export class PassportConfigService {
  get options(): PassportOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      // TODO: Временное решение, чтобы убедиться в том, что ручка паспорта долго отвечает
      timeout: 10000,
      headers: {
        Host: this.options.hostHeader,
      },
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'passport',
      useUserTicket: true,
    };
  }
}
