import { Injectable } from '@nestjs/common';
import { Context, TldService } from '@yandex-int/nest-common';

import { PassportConfigService } from './passport-config.service';

@Injectable()
export class PathsConfigService {
  constructor(
    private context: Context,
    private tldService: TldService,
    private passportConfigService: PassportConfigService,
  ) {}

  get passportProfileUrl(): string {
    return `https://${this.passportHost}/profile`;
  }

  get passportAuthUpdateUrl(): string {
    return `https://${this.passportHost}/auth/update/?retpath=${this.retpath}`;
  }

  get passportAuthUrl(): string {
    return `https://${this.passportHost}/auth/?retpath=${this.retpath}&noreturn=1`;
  }

  private get retpath() {
    const { hostname, originalUrl } = this.context.req;

    return encodeURIComponent(`https://${hostname}${originalUrl}`);
  }

  private get passportHost() {
    const tld = this.tldService.getTld() ?? 'ru';

    return this.passportConfigService.options.host.replace(/{tld}/, tld);
  }
}
