import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface SearchOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<SearchOptions> = {
  common: {
    url: 'https://msearch-proxy-test.search.yandex.net:10431',
    timeout: 4500,
  },
  production: {
    url: 'http://new-msearch-proxy.mail.yandex.net:8051',
  },
};

@Injectable()
export class SearchConfigService {
  get options(): SearchOptions {
    return getEnvConfig(config);
  }

  get endpoint(): string {
    return '/api/async/passport/multisearch';
  }

  /**
   * Количество ответов в одном источнике.
   */
  get chunkAmount(): number {
    return 5;
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'search',
      useUserTicket: true,
    };
  }
}
