import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface SplitOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<SplitOptions> = {
  common: {
    url: 'https://bnpl.fintech.tst.yandex.net',
    timeout: 20000,
  },
  production: {
    url: 'https://bnpl.fintech.yandex.net',
  },
};

@Injectable()
export class SplitConfigService {
  get options(): SplitOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'bnpl',
      useUserTicket: true,
    };
  }
}
