import { Injectable } from '@nestjs/common';
import type { HttpConfig, HttpModuleOptions } from '@server/shared/http/types';

import { EnvConfig, getEnvConfig } from '../env-config';

interface TrustOptions {
  url: string;
  timeout: number;
}

const config: EnvConfig<TrustOptions> = {
  common: {
    url: 'https://api.trust.test.yandex.net',
    timeout: 2500,
  },
  production: {
    url: 'https://api.trust.yandex.net',
  },
};

@Injectable()
export class TrustConfigService {
  get options(): TrustOptions {
    return getEnvConfig(config);
  }

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.options.url,
      timeout: this.options.timeout,
      responseType: 'json',
    };
  }

  createHttpConfig(): HttpConfig {
    return {
      tvmTargetName: 'trust',
      useUserTicket: true,
    };
  }
}
