import { Injectable } from '@nestjs/common';
import { TvmOptions } from '@yandex-int/nest-infra';

import { EnvConfig, getEnvConfig } from '../env-config';

const config: EnvConfig<TvmOptions> = {
  common: {
    clientId: 'frontend',
    serverUrl: process.env.DEPLOY_TVM_TOOL_URL || 'http://localhost:8002',
    destinations: [
      'blackbox',
      'bnpl',
      'ohio',
      'payments',
      'bills_backend',
      'search',
      'passport',
      'trust',
      'address',
      'documents',
      'disk',
      'familypay_backend',
    ],
    token: process.env.TVMTOOL_LOCAL_AUTHTOKEN || 'tvmtool-development-access-token',
    requestOptions: {
      family: 4,
    },
  },
};

@Injectable()
export class TvmConfigService {
  get options(): TvmOptions {
    return getEnvConfig(config);
  }
}
