import { Injectable } from '@nestjs/common';

import { EnvConfig, getEnvConfig } from '../env-config';

export interface YandexPayOptions {
  scriptSrc: string;
  merchantId: string;
  merchantName: string;
  gateway: string;
  gatewayId: string;
  env: 'SANDBOX' | 'TESTING' | 'PRODUCTION';
}

const config: EnvConfig<YandexPayOptions> = {
  common: {
    scriptSrc: 'https://test.pay.yandex.ru/sdk/v1/pay.js',
    merchantId: '18b3b6ac-6d17-41ff-ad6a-cbed3775c3e3',
    merchantName: 'passport-bills',
    gateway: 'yandex-trust',
    gatewayId: 'oplatagosuslug',
    env: 'TESTING',
  },
  production: {
    scriptSrc: 'https://pay.yandex.ru/sdk/v1/pay.js',
    merchantId: '72360794-5752-4570-aad8-543ed3d22834',
    merchantName: 'passport-bills',
    gateway: 'mobimoney',
    gatewayId: 'oplatagosuslug',
    env: 'PRODUCTION',
  },
};

@Injectable()
export class YandexPayConfigService {
  get options(): YandexPayOptions {
    return getEnvConfig(config);
  }
}
