import { Module } from '@nestjs/common';
import { PassportModule } from '@server/shared/passport';

import { AccountsResolver } from './accounts.resolver';
import { AccountsService } from './accounts.service';
import { PhoneService } from './phone.service';
import { ProfileService } from './profile.service';
import { PublicIdService } from './publicId.service';
import { QuestionService } from './question.service';

@Module({
  imports: [PassportModule],
  providers: [
    AccountsResolver,
    AccountsService,
    PhoneService,
    QuestionService,
    PublicIdService,
    ProfileService,
  ],
})
export class AccountsModule {}
