export enum ConfirmationTrackStateExceptionReason {
  PRIMARY_PHONE_NOT_BOUND = 'PRIMARY_PHONE_NOT_BOUND',
  PRIMARY_PHONE_NOT_CONFIRMED = 'PRIMARY_PHONE_NOT_CONFIRMED',
  TRACK_ID_INVALID = 'TRACK_ID_INVALID',
  TRACK_INVALID_STATE = 'TRACK_INVALID_STATE',
}

export enum ToggleLoginWithPasswordAndSmsReason {
  PRIMARY_PHONE_NOT_FOUND = 'PRIMARY_PHONE_NOT_FOUND',
  UNKNOWN = 'UNKNOWN',
}

export class ReasonException<T> extends Error {
  readonly reason: T;

  constructor(message: string, reason: T) {
    super(message);

    this.reason = reason;
  }
}

export class ConfirmationTrackStateException extends ReasonException<ConfirmationTrackStateExceptionReason> {}

export class ToggleLoginWithPasswordAndSmsException extends ReasonException<ToggleLoginWithPasswordAndSmsReason> {}
