import { Injectable } from '@nestjs/common';
import {
  ProfileUpdateInput,
  ProfileUpdatePayload,
  ProfileUpdateProblem,
} from '@server/graphql-schema';
import { fromModel } from '@server/shared/libs';
import { PassportService } from '@server/shared/passport';

@Injectable()
export class ProfileService {
  constructor(private passport: PassportService) {}

  async updateProfile(input: ProfileUpdateInput) {
    if (!input.trackId) {
      input.trackId = await this.passport.getTrackId();
    }

    const response = await this.passport.updateProfile({
      trackId: input.trackId,
      publicId: input.publicId ?? undefined,
    });

    if (response.status === 'error') {
      return fromModel(ProfileUpdateProblem, {
        reason: response.errors[0],
      });
    }

    return fromModel(ProfileUpdatePayload, {});
  }
}
