export type Location = {
  latitude: number;
  longitude: number;
};

export type Address = {
  address_line: string;
  building?: string;
  city?: string;
  comment?: string;
  country?: string;
  entrance?: string;
  floor?: string;
  id: string;
  intercom?: string;
  locality?: string;
  location: Location;
  owner_service: string;
  room?: string;
  street?: string;
  type: 'home' | 'work' | null;
};

export type AddressListResponse = {
  status: string;
  addresses: Address[];
};
