import { Module } from '@nestjs/common';
import { AddressConfigService } from '@server/config/services/address-config.service';
import { HttpModule } from '@server/shared/http';
import { StaticMapModule } from '@server/shared/static-map';

import { AddressResolver } from './address.resolver';
import { AddressService } from './address.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: AddressConfigService,
    }),
    StaticMapModule,
  ],
  providers: [AddressService, AddressResolver],
})
export class AddressModule {}
