import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import { CreateOrUpdateAddressInput, DeleteAddressInput } from '@server/graphql-schema';

import { AddressService } from './address.service';

@Resolver()
export class AddressResolver {
  constructor(private addressService: AddressService) {}

  @Query()
  addresses() {
    return this.addressService.getAddressList();
  }

  @Mutation()
  createOrUpdateAddress(@Args('input') input: CreateOrUpdateAddressInput) {
    return this.addressService.createOrUpdateAddress(input);
  }

  @Mutation()
  deleteAddress(@Args('input') input: DeleteAddressInput) {
    return this.addressService.deleteAddress(input);
  }
}
