import { Response } from 'express';

import { Controller, Get, Query, Res } from '@nestjs/common';
import { getYEnv } from '@server/config';
import { HttpService } from '@server/shared/http';
import { getAvatarsDomainPrefix } from '@server/shared/libs';

@Controller()
export class AvatarsProxyController {
  constructor(private http: HttpService) {}
  @Get('/personal/api/avatars-proxy')
  async index(@Query('path') path: string, @Res() res: Response) {
    const yenv = getYEnv();
    const domainPrefix = getAvatarsDomainPrefix(yenv);
    const upstreamResponse = await this.http.get(
      `https://avatars.${domainPrefix}.yandex.net${path}`,
      {
        responseType: 'arraybuffer',
      },
    );

    res.set('content-type', upstreamResponse.headers['content-type']);
    res.write(upstreamResponse.data);
    res.end();
  }
}
