import { Bill, Document } from './bills.interface';

export const documentReducer = (doc: Document): Document => {
  const formattedValue =
    doc.value.slice(0, 2) + ' ' + doc.value.slice(2, 4) + ' ' + doc.value.slice(4);

  return { ...doc, value: formattedValue };
};

export const billReducer = (bill: Bill): Bill => {
  return {
    ...bill,
    amount: bill.amount / 100,
    discounted_amount: bill.discounted_amount / 100,
    fee_amount: bill.fee_amount / 100,
  };
};
