export interface Bill {
  bill_id: string;
  supplier_bill_id: string;
  document_id: string;
  discount_date: string;
  uid?: number;
  kpp: string;
  account_number?: string;
  bik: string;
  inn: string;
  paid_amount?: number;
  discount_size: string;
  paid_date?: string;
  treasure_branch: string;
  dep_type: string;
  payee_name: string;
  bill_date: string;
  status: string;
  amount: number;
  oktmo: string;
  kbk: string;
  div_id: number;
  purpose: string;
  amount_to_pay: number;
  payer_name: string;
  discounted_amount: number;
  fee_amount: number;
  offense_name?: string;
  offense_place?: string;
  offense_date?: string;
  legal_act?: string;
  payment_deadline: string;
}

type BillsState = 'unregistered' | 'syncing' | 'completed';
type TransactionStatus = 'NEW' | 'PAID' | 'CANCELLED' | 'REFUNDED';

export interface BillsData {
  state: BillsState;
  bills: Bill[];
}

export interface Document {
  document_id: string;
  type: DocumentType;
  title: string;
  value: string;
  created: string;
  updated: string;
}

export interface DocumentsData {
  documents: Document[];
}

export interface DocumentData {
  document: Document;
}

export interface OrderData {
  order: {
    status: string;
    created: string;
    order_id: string;
    bill_ids: string[];
    updated: string;
  };
}

export interface BillPaymentStatus {
  transaction: {
    status: TransactionStatus;
    transaction_id: string;
  };
}

export interface BillPayment {
  transaction: {
    payer_full_name: string;
    acs_url: string;
    order_id: string;
    status: string;
    payment_method: string;
    amount: number;
    return_url: string;
    created: string;
    updated: string;
    transaction_id: string;
    payment_token: string;
    mpi_3ds_info: {
      browser_accept_header: string;
      browser_tz: string;
      browser_language: string;
      browser_screen_width: number;
      browser_user_agent: string;
      window_width: number;
      browser_javascript_enabled: boolean;
      browser_screen_height: number;
      window_height: number;
      browser_color_depth: number;
      browser_ip: string;
    };
  };
}

export interface DeleteResponse {
  status: string;
}

export type BillsResponse<T> = {
  status: string;
  data: T;
};
