import { Module } from '@nestjs/common';
import { BillsConfigService } from '@server/config';
import { HttpModule } from '@server/shared/http';

import { BillsController } from './bills.controller';
import { BillsResolver } from './bills.resolver';
import { BillsService } from './bills.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: BillsConfigService,
    }),
  ],
  providers: [BillsService, BillsResolver],
  exports: [BillsService],
  controllers: [BillsController],
})
export class BillsModule {}
