import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import {
  AddBillsDocumentInput,
  CreateOrderBillInput,
  DeleteBillsDocumentInput,
  StartOrderBillInput,
  UpdateBillsDocumentInput,
  getTransactionInput,
} from '@server/graphql-schema';

import { BillsService } from './bills.service';

@Resolver()
export class BillsResolver {
  constructor(private billsService: BillsService) {}

  @Query('bills')
  bills() {
    return this.billsService.getBills();
  }

  @Query('billsDocuments')
  billsDocuments() {
    return this.billsService.getDocuments();
  }

  @Mutation('restartBillsSearch')
  restartBillsSearch() {
    return this.billsService.restartSearch();
  }

  @Mutation('addBillsDocument')
  addBillsDocument(@Args('input') input: AddBillsDocumentInput) {
    return this.billsService.addDocument(input);
  }

  @Mutation('updateBillsDocument')
  updateBillsDocument(@Args('input') input: UpdateBillsDocumentInput) {
    return this.billsService.updateDocument(input);
  }

  @Mutation('deleteBillsDocument')
  deleteBillsDocument(@Args('input') input: DeleteBillsDocumentInput) {
    return this.billsService.deleteDocument(input);
  }

  @Mutation('createOrderBill')
  createOrderBill(@Args('input') input: CreateOrderBillInput) {
    return this.billsService.createOrder(input);
  }

  @Mutation('startOrderBill')
  startOrderBill(@Args('input') input: StartOrderBillInput) {
    return this.billsService.startOrder(input);
  }

  @Mutation('getTransaction')
  getTransaction(@Args('input') input: getTransactionInput) {
    return this.billsService.getTransaction(input);
  }
}
