import { Args, Mutation, Resolver } from '@nestjs/graphql';
import { ConfirmByPasswordInput } from '@server/graphql-schema';

import { ConfirmationService } from './confirmation.service';

@Resolver()
export class ConfirmationResolver {
  constructor(private confirmation: ConfirmationService) {}

  @Mutation('confirmByPassword')
  confirmByPassword(@Args('input') input: ConfirmByPasswordInput) {
    return this.confirmation.confirmByPassword(input);
  }
}
