import { Module } from '@nestjs/common';
import { DiskConfigService } from '@server/config/services/disk-config.service';
import { HttpModule } from '@server/shared/http';

import { DiskResolver } from './disk.resolver';
import { DiskService } from './disk.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: DiskConfigService,
    }),
  ],
  providers: [DiskService, DiskResolver],
})
export class DiskModule {}
