import { Args, Query, Resolver } from '@nestjs/graphql';
import { DocumentType } from '@server/graphql-schema';

import { DiskService } from './disk.service';

@Resolver()
export class DiskResolver {
  constructor(private diskService: DiskService) {}

  @Query('findDocuments')
  findDocuments(@Args('type') type: DocumentType) {
    return this.diskService.searchDiskResource(type);
  }
}
