import { Injectable } from '@nestjs/common';
import { DiskItem, DocumentType } from '@server/graphql-schema';
import { HttpService } from '@server/shared/http';
import { fromModel } from '@server/shared/libs';

import { SearchQuery } from './disk.constants';
import { SearchDiskData } from './disk.interface';

@Injectable()
export class DiskService {
  constructor(private http: HttpService) {}

  async searchDiskResource(type: DocumentType) {
    const response = await this.http.get<SearchDiskData>(`/v1/disk/resources/search`, {
      params: {
        query: SearchQuery[type],
        preview_size: 'L',
        preview_allow_big_size: true,
      },
    });

    const items = response.data.items
      .filter((item) => item.preview)
      .map((item) =>
        fromModel(DiskItem, {
          path: item.path,
          preview: item.preview,
          name: item.name,
        }),
      );

    return items;
  }
}
