import type { Express } from 'express';

import { Body, Controller, Post, UploadedFile, UseInterceptors } from '@nestjs/common';
import { FileInterceptor } from '@nestjs/platform-express';
import { DocumentType } from '@server/graphql-schema';

import { DocumentsService } from './documents.service';

@Controller()
export class DocumentsController {
  constructor(private documentsService: DocumentsService) {}

  @Post('/personal/api/documents/upload')
  @UseInterceptors(FileInterceptor('file'))
  uploadFile(
    @UploadedFile() file: Express.Multer.File,
    // TODO: delete type
    @Body('type') type: DocumentType,
    @Body('id') id?: string,
    @Body('save') save?: 'true' | 'false',
  ) {
    return this.documentsService.uploadImage(file, type, id, save);
  }
}
