import { DocumentGender } from '@server/graphql-schema';

export enum DocumentType {
  BIRTH_CERTIFICATE = 'birth_certificate',
  DRIVER_LICENSE = 'driver_license',
  INN = 'inn',
  INTERNATIONAL_ID = 'international_id',
  MEDICAL_INSURANCE = 'medical_insurance',
  NATIONAL_ID = 'national_id',
  SNILS = 'snils',
  VEHICLE_REGISTRATION_CERTIFICATE = 'vehicle_registration_certificate',
  VOLUNTARY_MEDICAL_INSURANCE = 'voluntary_medical_insurance',
}

export interface DocumentImage {
  image_id: string;
  original_uri?: string;
  original_url: string;
  original_width?: number;
  original_height?: number;
  preview_uri?: string;
  preview_url?: string;
  preview_width?: number;
  preview_height?: number;
}

export interface DocumentData {
  // поле id для получения документа определенной версии
  // мы его не используем
  // original_id выдает последнюю версию документа
  // то, что нам нужно
  id: string;
  original_id: string;
  user_id: string;
  user_type: string;
  doc_type: DocumentType;
  images: DocumentImage[];
  verification_status?: null | 'NONE' | 'FULL';
  // TODO: delete preview_url, original_url
  preview_url?: string;
  original_url?: string;
  doc_number?: string;
  first_name?: string;
  first_name_lat?: string;
  last_name?: string;
  last_name_lat?: string;
  middle_name?: string;
  middle_name_lat?: string;
  birth_date?: string;
  birth_place?: string;
  birth_place_lat?: string;
  gender?: DocumentGender;
  issued_by?: string;
  issued_by_lat?: string;
  issuer_subdivision_code?: string;
  issued_city?: string;
  issued_city_lat?: string;
  issue_date?: string;
  end_date?: string;
  registration_address?: string;
  registration_address_line?: string;
  citizenship?: string;
  citizenship_lat?: string;
  category?: string;
  additional_information?: string;
  blank?: string;
  series?: string;
  insurer_org?: string;
  birth_akt?: string;
  father_last_name?: string;
  father_first_name?: string;
  father_middle_name?: string;
  father_citizenship?: string;
  father_birth_date?: string;
  father_nationality?: string;
  mother_last_name?: string;
  mother_first_name?: string;
  mother_middle_name?: string;
  mother_citizenship?: string;
  mother_birth_date?: string;
  mother_nationality?: string;
  registration_place?: string;
  issue_place?: string;
  car_number?: string;
  vin?: string;
  model?: string;
  model_lat?: string;
  type?: string;
  year?: string;
  shasi_number?: string;
  body_number?: string;
  color?: string;
  power?: string;
  eco_class?: string;
  max_weight?: string;
  without_load_weight: string;
  temporary_reg?: string;
  pts?: string;
}

export interface DocumentsData {
  more: string;
  documents: DocumentData[];
}

// get document by id
export type DocumentByIdApiSuccessResponse = {
  status: 'ok';
} & DocumentData;

export interface DocumentByIdApiErrorResponse {
  status: 'error';
}

export type DocumentByIdApiResponse = DocumentByIdApiErrorResponse | DocumentByIdApiSuccessResponse;

// delete document
export interface DeleteDocumentApiErrorResponse {
  status: 'error';
}

export interface DeleteDocumentApiSuccessResponse {
  status: 'ok';
}

export type DeleteDocumentApiResponse =
  | DeleteDocumentApiErrorResponse
  | DeleteDocumentApiSuccessResponse;
