import { Module } from '@nestjs/common';
import { DocumentsConfigService } from '@server/config';
import { HttpModule } from '@server/shared/http';

import { DocumentsController } from './documents.controller';
import { DocumentsResolver } from './documents.resolver';
import { DocumentsService } from './documents.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: DocumentsConfigService,
    }),
  ],
  controllers: [DocumentsController],
  providers: [DocumentsService, DocumentsResolver],
})
export class DocumentsModule {}
