import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import { AddDocumentInput, DocumentType, UpdateDocumentInput } from '@server/graphql-schema';

import { DocumentsService } from './documents.service';
import { CopyDocumentsFromDiskInput } from './models/copy-documents-from-disk.input';
import { DeleteDocumentInput } from './models/delete-document.input';

@Resolver()
export class DocumentsResolver {
  constructor(private documentsService: DocumentsService) {}

  @Query('document')
  document(@Args('id') id: string) {
    return this.documentsService.getDocumentById(id);
  }

  @Query('documents')
  documents(@Args('type') type?: DocumentType) {
    return this.documentsService.getDocumentsList(type);
  }

  @Mutation('addDocument')
  addDocument(@Args('input') input: AddDocumentInput) {
    return this.documentsService.addDocument(input);
  }

  @Mutation('updateDocument')
  updateDocument(@Args('input') input: UpdateDocumentInput) {
    return this.documentsService.updateDocument(input);
  }

  @Mutation('deleteDocument')
  deleteDocument(@Args('input') input: DeleteDocumentInput) {
    return this.documentsService.deleteDocument(input);
  }

  @Mutation('copyDocumentsFromDisk')
  copyDocumentsFromDisk(
    @Args('input') input: CopyDocumentsFromDiskInput,
    @Args('type') type: DocumentType,
  ) {
    return this.documentsService.copyDocumentsFromDisk(input, type);
  }
}
