import { Injectable } from '@nestjs/common';
import { GeobaseService } from '@server/shared/geobase';
import { Context } from '@yandex-int/nest-common';

import countriesLangsMap from './countries.json';
import timezonesLangsMap from './timezones.json';

@Injectable()
export class LocationService {
  constructor(private context: Context, private geobaseService: GeobaseService) {}
  async getLocation() {
    const region = this.geobaseService.getRegionIdByIp(this.context.req.ip);
    const country = this.geobaseService.getCountryRegion(region);
    const timezone = this.geobaseService.getTimezoneById(region).name;

    return {
      countryCode: country.iso_name.toLowerCase(),
      timezone,
    };
  }

  async getLocationOptions() {
    const lang = this.context.req.langdetect.id;

    return {
      countries: countriesLangsMap[lang as keyof typeof countriesLangsMap],
      timezones: timezonesLangsMap[lang as keyof typeof countriesLangsMap],
    };
  }
}
