import { saftyParseFloat } from '@shared/helpers';

import { OrderItem } from '../ohio.interface';

const hiddenItemsName = ['Eda services', 'none'];

export function orderItemReducer(orderItem: OrderItem): OrderItem {
  return {
    ...orderItem,
    price: saftyParseFloat(orderItem.amount),
    hidden: orderItem.hidden || hiddenItemsName.includes(orderItem.name),
  };
}
