import { BunkerOhioService } from '../../shared/bunker/bunker.interface';

type OhioBackendResponse<T> = {
  status: number;
  error?: string;
  data: T;
};

export type EdadealCashbackResponse = OhioBackendResponse<{
  amount: string;
}>;

export type EdadealDataResponse = {
  status: 'blocked' | 'no_binding' | 'in_progress' | 'has_binding';
  urls: {
    touch: string;
    desktop: string;
  };
};

export type EdadealDataContext = {
  hasBinding?: boolean;
  url: string;
  iframeSrc: string;
  amount: number | null;
};

export type Service = {
  service_id: string;
  subservice_id: string;
};

export type ServicesResponse = OhioBackendResponse<{
  services: Service[];
}>;

type FamilyUser = {
  initiator_uid: number;
};

export type FamilyPayResponse = OhioBackendResponse<{
  familypay_users: FamilyUser[];
}>;

export interface ExtendedService extends BunkerOhioService {
  id: string;
}

type OrderStatus = 'paid' | 'cancelled' | 'refunded' | 'hold';

export interface OrderItem {
  amount: string;
  currency: string;
  name: string;
  nds: string;
  price: number;
  hidden?: boolean;
  alias?: string;
}

interface RawOrderRefund {
  items: OrderItem[];
  total: string;
  currency: string;
}

export interface OrderRefund {
  items?: OrderItem[];
  total: number;
  currency: string;
  paymentMethod: string;
  account?: string;
}

interface ServiceData {
  subservice_id: string;
  payment_method: 'composite' | string;
  user_account: string;
  trust_group_id: string | null;
}

export interface RawOrder {
  created: string;
  currency: string;
  items: OrderItem[];
  order_id: number;
  refunds: RawOrderRefund[];
  service_data: ServiceData;
  subservice_id: string;
  status: OrderStatus;
  total: string;
  trust_payment_id: string;
  trust_purchase_token: string;
  initiator_uid?: string;
  receipt_url?: string;
  retailer_name?: string;
  retailer_icon?: string;
  cashback?: {
    type: 'SUCCESS' | 'FAIL';
    amount: string;
  };
  features?: {
    is_advance: boolean;
    operation_type: number;
  };
  source: 'trust' | 'yandexpay';
  merchant_id?: string;
  gateway_name?: string;
}

export type PaymentsDataResponse = OhioBackendResponse<{
  next: {
    created_keyset: string;
    order_id_keyset: number;
  };
  orders: RawOrder[];
}>;

export type Order = {
  id: string;
  total: number;
  status: string;
  items?: OrderItem[];
  refunds?: OrderRefund[];
  created: string;
  serviceId: string;
  service: BunkerOhioService;
  orderId: string;
  plus: number;
  paymentTypes?: PaymentType[];
  receiptsEnabled: boolean;
  currency: string;
  fake?: boolean;
  refundOnly?: boolean;
  purchaseToken: string;
  paymentId: string;
  initiatorUid?: string;
  isReceipt?: boolean;
  receiptUrl?: string;
  retailerName?: string;
  retailerIcon?: string;
  cashback?: number;
  source: 'trust' | 'yandexpay';
};

export type OrderList = {
  edges: Order[];
  pageInfo: PageInfo;
};

export type PageInfo = {
  endCursor?: string | null;
  startCursor?: string | null;
  hasNextPage: boolean;
  hasPreviousPage: boolean;
};

export type PaymentType = {
  method: string;
  price: number;
  account?: string;
  currency?: string;
};

export enum OperationType {
  Arrival = 1,
  ReturnArrival,
  Expence,
  ExpenseRefund,
}

export type ReceiptResponse = OhioBackendResponse<{
  receipts: RawReceipt[];
}>;

interface RawReceipt {
  receipt_type: string;
  url: string;
  payments: ReceiptPayment[];
  timestamp: string;
}

export interface Receipt {
  url: string;
  amount?: number[];
  timestamp?: string;
  type?: string;
}

interface ReceiptPayment {
  amount: string;
  payment_type: string;
}

export interface ContextOptions {
  familyMode?: boolean;
}
