import { Module } from '@nestjs/common';
import { OhioConfigService } from '@server/config';
import { BlackboxApiModule } from '@server/features/blackbox-api';
import { BunkerModule } from '@server/shared/bunker';
import { HttpModule } from '@server/shared/http';
import { PassportModule } from '@server/shared/passport';

import { OhioResolver } from './ohio.resolver';
import { OhioService } from './ohio.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: OhioConfigService,
    }),
    BunkerModule,
    BlackboxApiModule,
    PassportModule,
  ],
  providers: [OhioService, OhioResolver],
  exports: [OhioService],
})
export class OhioModule {}
