import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import { AccountBindBankCardInput } from '@server/graphql-schema';
import { PassportService } from '@server/shared/passport';

import { OhioService } from './ohio.service';

@Resolver()
export class OhioResolver {
  constructor(private ohioService: OhioService, private passportService: PassportService) {}

  @Query('paymentsContext')
  paymentsContext(
    @Args('familyMode', { type: () => Boolean, nullable: true }) familyMode?: boolean,
  ) {
    return this.ohioService.getContext({ familyMode });
  }

  @Query('edadealData')
  edadealData() {
    return this.ohioService.getEdadealData();
  }

  @Query('paymentsData')
  paymentsData(
    @Args('alias', { type: () => String, nullable: true }) alias?: string,
    @Args('user', { type: () => String, nullable: true }) user?: string,
    @Args('after', { type: () => String, nullable: true }) after?: string,
  ) {
    return this.ohioService.getPayments({ alias, after, user });
  }

  @Query('paymentById')
  paymentById(@Args('paymentId', { type: () => String }) paymentId: string) {
    return this.ohioService.getPaymentById(paymentId);
  }

  @Query('receiptsByToken')
  receiptsByToken(@Args('purchaseToken', { type: () => String }) purchaseToken: string) {
    return this.ohioService.getReceiptByPurchaseToken(purchaseToken);
  }

  @Query('accountBankCards')
  accountBankCards() {
    return this.passportService.getBillingListPaymentMethods();
  }

  @Mutation('accountUnbindBankCard')
  accountUnbindBankCard(@Args('cardId') cardId: string) {
    return this.passportService.unbindCard(cardId);
  }

  @Mutation('accountBindBankCard')
  accountBindBankCard(@Args('input') input: AccountBindBankCardInput) {
    return this.passportService.createBinding(input);
  }
}
