import { Controller, Get, Query } from '@nestjs/common';

import { SearchService } from './search.service';

@Controller()
export class SearchController {
  constructor(private searchService: SearchService) {}

  @Get('/security/api/suggest')
  suggest() {
    return this.searchService.suggest();
  }

  @Get('/security/api/search')
  search(@Query('text') text: string) {
    return this.searchService.search(text);
  }
}
