import { Module } from '@nestjs/common';
import { SearchConfigService } from '@server/config';
import { HttpModule } from '@server/shared/http';

import { SearchController } from './search.controller';
import { SearchService } from './search.service';

@Module({
  imports: [
    HttpModule.forRootAsync({
      useExisting: SearchConfigService,
    }),
  ],
  providers: [SearchService],
  controllers: [SearchController],
})
export class SearchModule {}
