import { Injectable, InternalServerErrorException } from '@nestjs/common';
import { SearchConfigService } from '@server/config';
import { BlackboxService } from '@server/shared/blackbox';
import { HttpService } from '@server/shared/http';

import suggestMockData from './__mock__/suggest.mock';
import { SearchResult } from './search.interface';

@Injectable()
export class SearchService {
  constructor(
    private http: HttpService,
    private searchConfigService: SearchConfigService,
    private blackboxService: BlackboxService,
  ) {}

  async search(text: string): Promise<SearchResult> {
    try {
      const { endpoint, chunkAmount } = this.searchConfigService;
      const blackbox = await this.blackboxService.getBlackbox();
      const response = await this.http.get<SearchResult>(endpoint, {
        params: {
          request: text,
          uid: blackbox?.uid,
          length: chunkAmount,
        },
      });

      return response.data;
    } catch (error) {
      throw new InternalServerErrorException(error);
    }
  }

  async suggest() {
    return Promise.resolve(suggestMockData);
  }
}
