import type { Express } from 'express';

import { Controller, Post, UploadedFile, UseInterceptors } from '@nestjs/common';
import { FileInterceptor } from '@nestjs/platform-express';
import { PassportService } from '@server/shared/passport';

@Controller()
export class ViewerController {
  constructor(private passportService: PassportService) {}

  @Post('/personal/api/viewer/avatar-upload')
  @UseInterceptors(FileInterceptor('file'))
  uploadFile(@UploadedFile() file: Express.Multer.File) {
    return this.passportService.addAvatar(file);
  }
}
