import { Module } from '@nestjs/common';
import { PassportModule } from '@server/shared/passport';

import { LocationModule } from '../location';
import { ViewerController } from './viewer.controller';
import { ViewerResolver } from './viewer.resolver';
import { ViewerService } from './viewer.service';

@Module({
  imports: [LocationModule, PassportModule],
  providers: [ViewerService, ViewerResolver],
  exports: [ViewerService],
  controllers: [ViewerController],
})
export class ViewerModule {}
