import { Args, Mutation, Query, Resolver } from '@nestjs/graphql';
import { ProfileFieldName, ProfileFieldValidationInput, Viewer } from '@server/graphql-schema';
import { UpdatePersonalInfoInput } from '@server/graphql-schema';
import { fromModel } from '@server/shared/libs';
import { ValidationFieldName } from '@server/shared/passport/api-types';

import { LocationService } from '../location/location.service';
import { ViewerService } from './viewer.service';

@Resolver()
export class ViewerResolver {
  constructor(private locationService: LocationService, private viewerService: ViewerService) {}

  @Query('viewer')
  async viewer() {
    // TODO: для обратной совместимости смаплю старый тип здесь, когда все окончательно переедет на GraphQL надо будет поменять возвращаемый тип в сервисе
    const {
      uid,
      avatarId,
      displayName,
      fullName,
      havePlus,
      isChild,
      city,
      firstName,
      lastName,
      birthdate,
      hasPublicIdSet,
      publicId,
      gender,
      country,
      timezone,
      hasFamilyPlus,
    } = await this.viewerService.getCommonUserData();

    return fromModel(Viewer, {
      id: uid as string,
      avatarId,
      displayName: displayName ?? '',
      havePlus,
      isChild,
      birthdate,
      city,
      firstName,
      fullName,
      hasPublicIdSet,
      lastName,
      publicId,
      gender,
      country,
      timezone,
      hasFamilyPlus,
    });
  }

  @Mutation('viewerUpdatePersonalInfo')
  updatePersonalInfo(@Args('input') input: UpdatePersonalInfoInput) {
    return this.viewerService.updateUserData(input);
  }

  @Mutation('viewerValidatePersonalInfoField')
  validatePersonalInfoField(
    @Args('input')
    input: ProfileFieldValidationInput,
  ) {
    const validationFieldEnumMap: Record<ProfileFieldName, ValidationFieldName> = {
      [ProfileFieldName.DISPLAY_NAME]: 'display_name',
      [ProfileFieldName.FIRSTNAME]: 'firstname',
      [ProfileFieldName.LASTNAME]: 'lastname',
    };

    return this.viewerService.validatePersonalInfoField(
      validationFieldEnumMap[input.fieldName],
      input.fieldValue,
    );
  }
}
