/*
 * -------------------------------------------------------
 * THIS FILE WAS AUTOMATICALLY GENERATED (DO NOT MODIFY)
 * -------------------------------------------------------
 */

export type ID = string;
export type Int = number;
export type Float = number;
export type String = string;
export type Boolean = boolean;

type Nullable<T> = T | null;

export class Account {
  __typename?: 'Account' = 'Account';
  authType?: Nullable<AuthType>;
  canLoginWithQR: Boolean;
  emails: Array<Email>;
  id: ID;
  passwordInfo?: Nullable<PasswordInfo>;
  phones: Array<Phone>;
  publicId: String;
  question?: Nullable<Question>;
  type: AccountType;
}

export class AccountBindBankCardInput {
  __typename?: 'AccountBindBankCardInput' = 'AccountBindBankCardInput';
  domainSfx: String;
  lang: String;
  returnPath: String;
  templateTag: String;
  trackId: String;
}

export class AccountCreateBindBankCardResponse {
  __typename?: 'AccountCreateBindBankCardResponse' = 'AccountCreateBindBankCardResponse';
  status: String;
  url?: Nullable<String>;
}

export enum AccountType {
  FEDERAL = 'FEDERAL',
  KIDDISH = 'KIDDISH',
  KINOPOISK = 'KINOPOISK',
  KOLONKISH = 'KOLONKISH',
  LITE = 'LITE',
  MAILISH = 'MAILISH',
  NEOPHONISH = 'NEOPHONISH',
  NORMAL = 'NORMAL',
  PDD = 'PDD',
  PHONISH = 'PHONISH',
  SCHOLAR = 'SCHOLAR',
  SOCIAL = 'SOCIAL',
  SUPERLITE = 'SUPERLITE',
  UBER = 'UBER',
  YAMBOT = 'YAMBOT',
}

export class AccountUnbindBankdCardResponse {
  __typename?: 'AccountUnbindBankdCardResponse' = 'AccountUnbindBankdCardResponse';
  status: String;
}

export class AddBillsDocumentInput {
  __typename?: 'AddBillsDocumentInput' = 'AddBillsDocumentInput';
  title: String;
  type: String;
  value: String;
}

export class AddBirthCertificateInput {
  __typename?: 'AddBirthCertificateInput' = 'AddBirthCertificateInput';
  birthAkt?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  fatherBirthDate?: Nullable<String>;
  fatherCitizenship?: Nullable<String>;
  fatherFirstName?: Nullable<String>;
  fatherLastName?: Nullable<String>;
  fatherMiddleName?: Nullable<String>;
  fatherNationality?: Nullable<String>;
  firstName?: Nullable<String>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuePlace?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  motherBirthDate?: Nullable<String>;
  motherCitizenship?: Nullable<String>;
  motherFirstName?: Nullable<String>;
  motherLastName?: Nullable<String>;
  motherMiddleName?: Nullable<String>;
  motherNationality?: Nullable<String>;
  registrationPlace?: Nullable<String>;
  series?: Nullable<String>;
}

export class AddDocumentInput {
  __typename?: 'AddDocumentInput' = 'AddDocumentInput';
  birthCertificateInput?: Nullable<AddBirthCertificateInput>;
  driverLicenseInput?: Nullable<AddDriverLicenseInput>;
  innInput?: Nullable<AddInnInput>;
  internationalIdInput?: Nullable<AddInternationalIdInput>;
  medicalInsuranceInput?: Nullable<AddMedicalInsuranceInput>;
  nationalIdInput?: Nullable<AddNationalIdInput>;
  snilsInput?: Nullable<AddSnilsInput>;
  type: DocumentType;
  vehicleRegistrationCertificateInput?: Nullable<AddVehicleRegistrationCertificateInput>;
  voluntaryMedicalInsuranceInput?: Nullable<AddVoluntaryMedicalInsuranceInput>;
}

export class AddDocumentPayload {
  __typename?: 'AddDocumentPayload' = 'AddDocumentPayload';
  query: Query = {};
}

export class AddDocumentProblem {
  __typename?: 'AddDocumentProblem' = 'AddDocumentProblem';
  reason: AddDocumentProblemReason;
}

export enum AddDocumentProblemReason {
  INTERNAL = 'INTERNAL',
}

export type AddDocumentResult = AddDocumentPayload | AddDocumentProblem;

export class AddDriverLicenseInput {
  __typename?: 'AddDriverLicenseInput' = 'AddDriverLicenseInput';
  additionalInformation?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  category?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuedByLat?: Nullable<String>;
  issuedCity?: Nullable<String>;
  issuedCityLat?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  middleName?: Nullable<String>;
  middleNameLat?: Nullable<String>;
}

export class AddInnInput {
  __typename?: 'AddInnInput' = 'AddInnInput';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
}

export class AddInternationalIdInput {
  __typename?: 'AddInternationalIdInput' = 'AddInternationalIdInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  citizenship?: Nullable<String>;
  citizenshipLat?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
}

export class AddMedicalInsuranceInput {
  __typename?: 'AddMedicalInsuranceInput' = 'AddMedicalInsuranceInput';
  birthDate?: Nullable<String>;
  blank?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
}

export class AddNationalIdInput {
  __typename?: 'AddNationalIdInput' = 'AddNationalIdInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  registrationAddress?: Nullable<String>;
}

export class AddRecoveryEmailInput {
  __typename?: 'AddRecoveryEmailInput' = 'AddRecoveryEmailInput';
  email: String;
  redirectUrl: String;
  trackId?: Nullable<String>;
  validationUrl: String;
}

export class AddRecoveryEmailPayload {
  __typename?: 'AddRecoveryEmailPayload' = 'AddRecoveryEmailPayload';
  query: Query = {};
  trackId: String;
}

export class AddRecoveryEmailProblem {
  __typename?: 'AddRecoveryEmailProblem' = 'AddRecoveryEmailProblem';
  reason: AddRecoveryEmailProblemKind;
  trackId: String;
}

export enum AddRecoveryEmailProblemKind {
  ALREADY_CONFIRMED = 'ALREADY_CONFIRMED',
  EMAIL_INVALID = 'EMAIL_INVALID',
  INTERNAL = 'INTERNAL',
  IS_NATIVE = 'IS_NATIVE',
  PASSWORD_REQUIRED = 'PASSWORD_REQUIRED',
  TOO_MANY_REQUESTS = 'TOO_MANY_REQUESTS',
}

export type AddRecoveryEmailResult = AddRecoveryEmailPayload | AddRecoveryEmailProblem;

export class AddSnilsInput {
  __typename?: 'AddSnilsInput' = 'AddSnilsInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
}

export class AddVehicleRegistrationCertificateInput {
  __typename?: 'AddVehicleRegistrationCertificateInput' = 'AddVehicleRegistrationCertificateInput';
  additionalInformation?: Nullable<String>;
  bodyNumber?: Nullable<String>;
  carNumber?: Nullable<String>;
  category?: Nullable<String>;
  color?: Nullable<String>;
  docNumber?: Nullable<String>;
  ecoClass?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  maxWeight?: Nullable<String>;
  middleName?: Nullable<String>;
  model?: Nullable<String>;
  modelLat?: Nullable<String>;
  power?: Nullable<String>;
  pts?: Nullable<String>;
  registrationAddress?: Nullable<String>;
  shasiNumber?: Nullable<String>;
  temporaryReg?: Nullable<String>;
  vehicleType?: Nullable<String>;
  vin?: Nullable<String>;
  withoutLoadWeight?: Nullable<String>;
  year?: Nullable<String>;
}

export class AddVoluntaryMedicalInsuranceInput {
  __typename?: 'AddVoluntaryMedicalInsuranceInput' = 'AddVoluntaryMedicalInsuranceInput';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  images: Array<DocumentImageInput>;
  insurerOrg?: Nullable<String>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
}

export class Address {
  __typename?: 'Address' = 'Address';
  comment?: Nullable<String>;
  entrance?: Nullable<String>;
  floor?: Nullable<String>;
  fullText?: Nullable<String>;
  id: String;
  intercom?: Nullable<String>;
  previewUrl: String;
  region?: Nullable<String>;
  room?: Nullable<String>;
  shortText: String;
  street?: Nullable<String>;
  type: AddressType;
}

export enum AddressType {
  Home = 'Home',
  Other = 'Other',
  Work = 'Work',
}

export enum AuthType {
  PASSWORD_AND_SMS = 'PASSWORD_AND_SMS',
  PASSWORD_ONLY = 'PASSWORD_ONLY',
  SMS_ONLY = 'SMS_ONLY',
  YANDEX_KEY = 'YANDEX_KEY',
}

export class AvailableQuestion {
  __typename?: 'AvailableQuestion' = 'AvailableQuestion';
  id: ID;
  text: String;
}

export class BankCard {
  __typename?: 'BankCard' = 'BankCard';
  cardId: String;
  familyAdminUid?: Nullable<Int>;
  id: String;
  isFamilyCard?: Nullable<Boolean>;
  name: String;
  number: String;
  proto: String;
  system: String;
}

export class BankCardsData {
  __typename?: 'BankCardsData' = 'BankCardsData';
  cards: Array<BankCard>;
  status: String;
  trackId: String;
}

export class Bill {
  __typename?: 'Bill' = 'Bill';
  account_number?: Nullable<String>;
  amount: Float;
  amount_to_pay: Float;
  bik?: Nullable<String>;
  bill_date: String;
  bill_id: String;
  dep_type: String;
  discount_date: String;
  discount_size: String;
  discounted_amount: Float;
  div_id: Int;
  document_id: String;
  fee_amount: Float;
  inn?: Nullable<String>;
  kbk: String;
  kpp?: Nullable<String>;
  legal_act?: Nullable<String>;
  offense_date?: Nullable<String>;
  offense_name?: Nullable<String>;
  offense_place?: Nullable<String>;
  oktmo?: Nullable<String>;
  paid_amount?: Nullable<Float>;
  paid_date?: Nullable<String>;
  payee_name?: Nullable<String>;
  payer_name?: Nullable<String>;
  payment_deadline: String;
  purpose?: Nullable<String>;
  status: String;
  supplier_bill_id: String;
  treasure_branch: String;
  uid?: Nullable<Int>;
}

export class BillTransactionResponse {
  __typename?: 'BillTransactionResponse' = 'BillTransactionResponse';
  status: TransactionStatus;
  transaction_id: String;
}

export class BillsData {
  __typename?: 'BillsData' = 'BillsData';
  bills: Array<Bill>;
  state: String;
}

export class BillsDocument {
  __typename?: 'BillsDocument' = 'BillsDocument';
  created: String;
  document_id: String;
  title: String;
  type: BillsDocumentType;
  updated: String;
  value: String;
}

export enum BillsDocumentType {
  DRIVER_LICENSE = 'DRIVER_LICENSE',
  VEHICLE_REGISTRATION_CERTIFICATE = 'VEHICLE_REGISTRATION_CERTIFICATE',
}

export enum BillsStatus {
  completed = 'completed',
  syncing = 'syncing',
  unregistered = 'unregistered',
}

export class BirthCertificateDocument implements IDocument {
  __typename?: 'BirthCertificateDocument' = 'BirthCertificateDocument';
  birthAkt?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  fatherBirthDate?: Nullable<String>;
  fatherCitizenship?: Nullable<String>;
  fatherFirstName?: Nullable<String>;
  fatherLastName?: Nullable<String>;
  fatherMiddleName?: Nullable<String>;
  fatherNationality?: Nullable<String>;
  firstName?: Nullable<String>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuePlace?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  motherBirthDate?: Nullable<String>;
  motherCitizenship?: Nullable<String>;
  motherFirstName?: Nullable<String>;
  motherLastName?: Nullable<String>;
  motherMiddleName?: Nullable<String>;
  motherNationality?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  registrationPlace?: Nullable<String>;
  section: DocumentSection;
  series?: Nullable<String>;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class CardInfo {
  __typename?: 'CardInfo' = 'CardInfo';
  bound: Boolean;
  cardId: String;
  currency: String;
  maskedNumber: String;
  paySystem: String;
}

export class ClientMpiInfoInput {
  __typename?: 'ClientMpiInfoInput' = 'ClientMpiInfoInput';
  browser_color_depth: Int;
  browser_screen_height: Int;
  browser_screen_width: Int;
  browser_tz: String;
  window_height: Int;
  window_width: Int;
}

export class ConfirmByPasswordInput {
  __typename?: 'ConfirmByPasswordInput' = 'ConfirmByPasswordInput';
  password: String;
  trackId: String;
}

export class ConfirmByPasswordPayload {
  __typename?: 'ConfirmByPasswordPayload' = 'ConfirmByPasswordPayload';
  successful: Boolean;
}

export class ConfirmByPasswordProblem {
  __typename?: 'ConfirmByPasswordProblem' = 'ConfirmByPasswordProblem';
  raw: String;
  reason: ConfirmByPasswordProblemKind;
}

export enum ConfirmByPasswordProblemKind {
  CAPTCHA_REQUIRED = 'CAPTCHA_REQUIRED',
  INTERNAL = 'INTERNAL',
  PASSWORD_NOT_MATCHED = 'PASSWORD_NOT_MATCHED',
}

export type ConfirmByPasswordResult = ConfirmByPasswordPayload | ConfirmByPasswordProblem;

export class ConfirmRecoveryEmailByCodeInput {
  __typename?: 'ConfirmRecoveryEmailByCodeInput' = 'ConfirmRecoveryEmailByCodeInput';
  code: String;
  trackId: String;
}

export class ConfirmRecoveryEmailByCodePayload {
  __typename?: 'ConfirmRecoveryEmailByCodePayload' = 'ConfirmRecoveryEmailByCodePayload';
  query: Query = {};
}

export class ConfirmRecoveryEmailByCodeProblem {
  __typename?: 'ConfirmRecoveryEmailByCodeProblem' = 'ConfirmRecoveryEmailByCodeProblem';
  reason: ConfirmRecoveryEmailByCodeProblemKind;
}

export enum ConfirmRecoveryEmailByCodeProblemKind {
  ALREADY_CONFIRMED = 'ALREADY_CONFIRMED',
  INCORRECT_KEY = 'INCORRECT_KEY',
  INTERNAL = 'INTERNAL',
  KEY_CHECK_LIMIT_EXCEEDED = 'KEY_CHECK_LIMIT_EXCEEDED',
}

export type ConfirmRecoveryEmailByCodeResult =
  | ConfirmRecoveryEmailByCodePayload
  | ConfirmRecoveryEmailByCodeProblem;

export class ConfirmRecoveryEmailByLinkInput {
  __typename?: 'ConfirmRecoveryEmailByLinkInput' = 'ConfirmRecoveryEmailByLinkInput';
  code: String;
}

export class ConfirmRecoveryEmailByLinkPayload {
  __typename?: 'ConfirmRecoveryEmailByLinkPayload' = 'ConfirmRecoveryEmailByLinkPayload';
  query: Query = {};
}

export class ConfirmRecoveryEmailByLinkProblem {
  __typename?: 'ConfirmRecoveryEmailByLinkProblem' = 'ConfirmRecoveryEmailByLinkProblem';
  reason: ConfirmRecoveryEmailByLinkProblemKind;
}

export enum ConfirmRecoveryEmailByLinkProblemKind {
  ALREADY_CONFIRMED = 'ALREADY_CONFIRMED',
  INCORRECT_KEY = 'INCORRECT_KEY',
  INTERNAL = 'INTERNAL',
}

export type ConfirmRecoveryEmailByLinkResult =
  | ConfirmRecoveryEmailByLinkPayload
  | ConfirmRecoveryEmailByLinkProblem;

export class CopyDocumentsFromDiskInput {
  __typename?: 'CopyDocumentsFromDiskInput' = 'CopyDocumentsFromDiskInput';
  paths: Array<String>;
}

export class CopyDocumentsFromDiskPayload {
  __typename?: 'CopyDocumentsFromDiskPayload' = 'CopyDocumentsFromDiskPayload';
  query: Query = {};
}

export class CountryOption {
  __typename?: 'CountryOption' = 'CountryOption';
  code: String;
  name: String;
}

export class CreateOrUpdateAddressInput {
  __typename?: 'CreateOrUpdateAddressInput' = 'CreateOrUpdateAddressInput';
  comment?: Nullable<String>;
  entrance?: Nullable<String>;
  floor?: Nullable<String>;
  fullText: String;
  id?: Nullable<ID>;
  intercom?: Nullable<String>;
  room?: Nullable<String>;
  type: AddressType;
}

export class CreateOrUpdateAddressPayload {
  __typename?: 'CreateOrUpdateAddressPayload' = 'CreateOrUpdateAddressPayload';
  query: Query = {};
}

export class CreateOrUpdateAddressProblem {
  __typename?: 'CreateOrUpdateAddressProblem' = 'CreateOrUpdateAddressProblem';
  reason: CreateOrUpdateAddressProblemKind;
}

export enum CreateOrUpdateAddressProblemKind {
  INTERNAL = 'INTERNAL',
}

export type CreateOrUpdateAddressResult =
  | CreateOrUpdateAddressPayload
  | CreateOrUpdateAddressProblem;

export class CreateOrderBillInput {
  __typename?: 'CreateOrderBillInput' = 'CreateOrderBillInput';
  ids: Array<String>;
}

export class CreateOrderResponse {
  __typename?: 'CreateOrderResponse' = 'CreateOrderResponse';
  created: String;
  order_id: String;
  status: String;
  updated: String;
}

export class DefaultResponse {
  __typename?: 'DefaultResponse' = 'DefaultResponse';
  status: String;
}

export class DeleteAddressInput {
  __typename?: 'DeleteAddressInput' = 'DeleteAddressInput';
  id: ID;
}

export class DeleteAddressPayload {
  __typename?: 'DeleteAddressPayload' = 'DeleteAddressPayload';
  query: Query = {};
}

export class DeleteAddressProblem {
  __typename?: 'DeleteAddressProblem' = 'DeleteAddressProblem';
  reason: DeleteAddressProblemKind;
}

export enum DeleteAddressProblemKind {
  INTERNAL = 'INTERNAL',
}

export type DeleteAddressResult = DeleteAddressPayload | DeleteAddressProblem;

export class DeleteBillsDocumentInput {
  __typename?: 'DeleteBillsDocumentInput' = 'DeleteBillsDocumentInput';
  id: String;
}

export class DeleteDocumentInput {
  __typename?: 'DeleteDocumentInput' = 'DeleteDocumentInput';
  id: String;
}

export class DeleteDocumentPayload {
  __typename?: 'DeleteDocumentPayload' = 'DeleteDocumentPayload';
  query: Query = {};
}

export class DeleteDocumentProblem {
  __typename?: 'DeleteDocumentProblem' = 'DeleteDocumentProblem';
  reason: DeleteDocumentProblemReason;
}

export enum DeleteDocumentProblemReason {
  INTERNAL = 'INTERNAL',
}

export type DeleteDocumentResult = DeleteDocumentPayload | DeleteDocumentProblem;

export class DisableLoginWithQRPayload {
  __typename?: 'DisableLoginWithQRPayload' = 'DisableLoginWithQRPayload';
  account: Account;
}

export class DiskItem {
  __typename?: 'DiskItem' = 'DiskItem';
  name: String;
  path: String;
  preview: String;
}

export class DisplayName {
  __typename?: 'DisplayName' = 'DisplayName';
  defaultAvatar?: Nullable<String>;
  name?: Nullable<String>;
}

export type Document =
  | BirthCertificateDocument
  | DriverLicenseDocument
  | InnDocument
  | InternationalIdDocument
  | MedicalInsuranceDocument
  | NationalIdDocument
  | SnilsDocument
  | VehicleRegistrationCertificateDocument
  | VoluntaryMedicalInsuranceDocument;

export class DocumentByIdProblem {
  __typename?: 'DocumentByIdProblem' = 'DocumentByIdProblem';
  reason: DocumentByIdProblemReason;
}

export enum DocumentByIdProblemReason {
  NOT_FOUND = 'NOT_FOUND',
}

export type DocumentByIdResult =
  | BirthCertificateDocument
  | DocumentByIdProblem
  | DriverLicenseDocument
  | InnDocument
  | InternationalIdDocument
  | MedicalInsuranceDocument
  | NationalIdDocument
  | SnilsDocument
  | VehicleRegistrationCertificateDocument
  | VoluntaryMedicalInsuranceDocument;

export enum DocumentGender {
  FEMALE = 'FEMALE',
  MALE = 'MALE',
}

export class DocumentImage {
  __typename?: 'DocumentImage' = 'DocumentImage';
  id: ID;
  originalHeight?: Nullable<Int>;
  originalUri?: Nullable<String>;
  originalUrl: String;
  originalWidth?: Nullable<Int>;
  previewHeight?: Nullable<Int>;
  previewUri?: Nullable<String>;
  previewUrl?: Nullable<String>;
  previewWidth?: Nullable<Int>;
}

export class DocumentImageInput {
  __typename?: 'DocumentImageInput' = 'DocumentImageInput';
  id: ID;
  originalHeight?: Nullable<Int>;
  originalUri?: Nullable<String>;
  originalUrl: String;
  originalWidth?: Nullable<Int>;
  previewHeight?: Nullable<Int>;
  previewUri?: Nullable<String>;
  previewUrl?: Nullable<String>;
  previewWidth?: Nullable<Int>;
}

export enum DocumentSection {
  FINANCE = 'FINANCE',
  HEALTH = 'HEALTH',
  PERSONAL = 'PERSONAL',
  TRANSPORT = 'TRANSPORT',
}

export enum DocumentType {
  BIRTH_CERTIFICATE = 'BIRTH_CERTIFICATE',
  DRIVER_LICENSE = 'DRIVER_LICENSE',
  INN = 'INN',
  INTERNATIONAL_ID = 'INTERNATIONAL_ID',
  MEDICAL_INSURANCE = 'MEDICAL_INSURANCE',
  NATIONAL_ID = 'NATIONAL_ID',
  SNILS = 'SNILS',
  VEHICLE_REGISTRATION_CERTIFICATE = 'VEHICLE_REGISTRATION_CERTIFICATE',
  VOLUNTARY_MEDICAL_INSURANCE = 'VOLUNTARY_MEDICAL_INSURANCE',
}

export class DriverLicenseDocument implements IDocument {
  __typename?: 'DriverLicenseDocument' = 'DriverLicenseDocument';
  additionalInformation?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  category?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuedByLat?: Nullable<String>;
  issuedCity?: Nullable<String>;
  issuedCityLat?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  middleName?: Nullable<String>;
  middleNameLat?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class EdadealData {
  __typename?: 'EdadealData' = 'EdadealData';
  amount?: Nullable<Float>;
  hasBinding: Boolean;
  iframeSrc: String;
  url: String;
}

export class Email {
  __typename?: 'Email' = 'Email';
  address: String;
  email: String;
  isConfirmed: Boolean;
  isPrimary: Boolean;
  isUnsafe: Boolean;
  type: EmailType;
}

export enum EmailType {
  EXTERNAL = 'EXTERNAL',
  NATIVE = 'NATIVE',
}

export class EnableLoginWithQRPayload {
  __typename?: 'EnableLoginWithQRPayload' = 'EnableLoginWithQRPayload';
  account: Account;
}

export class ExternalAccount {
  __typename?: 'ExternalAccount' = 'ExternalAccount';
  allowAuth: Boolean;
  displayName: String;
  firstName?: Nullable<String>;
  id: ID;
  lastName?: Nullable<String>;
  provider: ExternalAccountProvider;
}

export class ExternalAccountProvider {
  __typename?: 'ExternalAccountProvider' = 'ExternalAccountProvider';
  id: ID;
  name: ExternalAccountProviderName;
}

export enum ExternalAccountProviderName {
  APPLE = 'APPLE',
  ESIA = 'ESIA',
  FACEBOOK = 'FACEBOOK',
  GOOGLE = 'GOOGLE',
  MAILRU = 'MAILRU',
  ODNOKLASSNIKI = 'ODNOKLASSNIKI',
  TWITTER = 'TWITTER',
  VK = 'VK',
}

export class Family {
  __typename?: 'Family' = 'Family';
  info?: Nullable<FamilyInfo>;
  invites: Array<FamilyInvite>;
  kids: Array<FamilyKid>;
  members: Array<FamilyMember>;
  pay?: Nullable<FamilyPay>;
  settings?: Nullable<FamilySettings>;
}

export class FamilyInfo {
  __typename?: 'FamilyInfo' = 'FamilyInfo';
  adminUid: String;
  id: String;
}

export class FamilyInvite {
  __typename?: 'FamilyInvite' = 'FamilyInvite';
  contact: String;
  id: String;
  sendMethod: String;
}

export class FamilyKid {
  __typename?: 'FamilyKid' = 'FamilyKid';
  avatar?: Nullable<String>;
  birthday?: Nullable<String>;
  contentRating: Int;
  gender?: Nullable<Int>;
  musicRating: Int;
  name?: Nullable<String>;
  placeId: String;
  uid: String;
  videoRating: Int;
}

export class FamilyMember {
  __typename?: 'FamilyMember' = 'FamilyMember';
  avatar: String;
  hasPlus: Boolean;
  hasSecurePhone?: Nullable<Boolean>;
  isAdmin: Boolean;
  name: String;
  placeId: String;
  uid: String;
}

export class FamilyPay {
  __typename?: 'FamilyPay' = 'FamilyPay';
  cardInfo?: Nullable<CardInfo>;
  userRestrictions: Array<Restriction>;
}

export class FamilySettings {
  __typename?: 'FamilySettings' = 'FamilySettings';
  maxCapacity: Int;
  maxKids: Int;
}

export class FamilyUser {
  __typename?: 'FamilyUser' = 'FamilyUser';
  avatar: String;
  name: String;
  uid: String;
}

export class FuturePayment {
  __typename?: 'FuturePayment' = 'FuturePayment';
  amount: Float;
  id?: Nullable<ID>;
  iframeUrl?: Nullable<String>;
  nextPaymentAt: String;
  service: String;
  type: FuturePaymentType;
}

export enum FuturePaymentType {
  SPLIT = 'SPLIT',
}

export interface IDocument {
  id: ID;
  images: Array<DocumentImage>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class InnDocument implements IDocument {
  __typename?: 'InnDocument' = 'InnDocument';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class InternationalIdDocument implements IDocument {
  __typename?: 'InternationalIdDocument' = 'InternationalIdDocument';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  citizenship?: Nullable<String>;
  citizenshipLat?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class Limit {
  __typename?: 'Limit' = 'Limit';
  limitMode: String;
  value: Int;
}

export class LocationsOptions {
  __typename?: 'LocationsOptions' = 'LocationsOptions';
  countries: Array<CountryOption>;
  timezones: Array<TimezoneOption>;
}

export class MedicalInsuranceDocument implements IDocument {
  __typename?: 'MedicalInsuranceDocument' = 'MedicalInsuranceDocument';
  birthDate?: Nullable<String>;
  blank?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class Mpi3dsInfo {
  __typename?: 'Mpi3dsInfo' = 'Mpi3dsInfo';
  browser_accept_header?: Nullable<String>;
  browser_color_depth: Int;
  browser_ip: String;
  browser_javascript_enabled: Boolean;
  browser_language: String;
  browser_screen_height: Int;
  browser_screen_width: Int;
  browser_tz: String;
  browser_user_agent: String;
  window_height: Int;
  window_width: Int;
}

export class Mutation {
  __typename?: 'Mutation' = 'Mutation';
}

export class NationalIdDocument implements IDocument {
  __typename?: 'NationalIdDocument' = 'NationalIdDocument';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  registrationAddress?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class PageInfo {
  __typename?: 'PageInfo' = 'PageInfo';
  endCursor?: Nullable<String>;
  hasNextPage: Boolean;
  hasPreviousPage: Boolean;
  startCursor?: Nullable<String>;
}

export class PasswordInfo {
  __typename?: 'PasswordInfo' = 'PasswordInfo';
  updatedAt: Timestamp;
}

export class Payment {
  __typename?: 'Payment' = 'Payment';
  cashback?: Nullable<Float>;
  created: String;
  currency: String;
  fake?: Nullable<Boolean>;
  initiatorUid?: Nullable<String>;
  isReceipt?: Nullable<Boolean>;
  items?: Nullable<Array<PaymentItem>>;
  orderId: String;
  paymentId: String;
  paymentTypes?: Nullable<Array<PaymentType>>;
  plus?: Nullable<Float>;
  purchaseToken: String;
  receiptUrl?: Nullable<String>;
  receiptsEnabled: Boolean;
  refundOnly?: Nullable<Boolean>;
  refunds?: Nullable<Array<PaymentRefund>>;
  retailerIcon?: Nullable<String>;
  retailerName?: Nullable<String>;
  service: Service;
  serviceId: String;
  source?: Nullable<String>;
  status: String;
  total: Float;
}

export class PaymentItem {
  __typename?: 'PaymentItem' = 'PaymentItem';
  alias?: Nullable<String>;
  amount: String;
  currency: String;
  hidden?: Nullable<Boolean>;
  name: String;
  nds: String;
  price: Float;
}

export class PaymentRefund {
  __typename?: 'PaymentRefund' = 'PaymentRefund';
  account?: Nullable<String>;
  currency: String;
  items?: Nullable<Array<PaymentItem>>;
  paymentMethod: String;
  total: Float;
}

export class PaymentType {
  __typename?: 'PaymentType' = 'PaymentType';
  account?: Nullable<String>;
  currency?: Nullable<String>;
  method: String;
  price: Float;
}

export class PaymentsContext {
  __typename?: 'PaymentsContext' = 'PaymentsContext';
  familyData?: Nullable<Array<FamilyUser>>;
  plusServiceData: PlusService;
  services: Array<Service>;
}

export class PaymentsData {
  __typename?: 'PaymentsData' = 'PaymentsData';
  edges: Array<Payment>;
  pageInfo: PageInfo;
}

export class Phone {
  __typename?: 'Phone' = 'Phone';
  id: ID;
  isDefault: Boolean;
  isPrimary: Boolean;
  number: String;
  operation?: Nullable<PhoneOperation>;
}

export class PhoneOperation {
  __typename?: 'PhoneOperation' = 'PhoneOperation';
  finishedAt: Timestamp;
  id: ID;
  inQuarantine: Boolean;
  isOwner: Boolean;
  startedAt: Timestamp;
  type: PhoneOperationType;
}

export enum PhoneOperationType {
  ALIASIFY = 'ALIASIFY',
  BIND = 'BIND',
  DEALIASIFY = 'DEALIASIFY',
  MARK = 'MARK',
  REMOVE = 'REMOVE',
  REPLACE = 'REPLACE',
  SECURIFY = 'SECURIFY',
}

export class PlusService {
  __typename?: 'PlusService' = 'PlusService';
  iconUrl: String;
  serviceName: String;
  splashUrl: String;
}

export enum ProfileFieldName {
  DISPLAY_NAME = 'DISPLAY_NAME',
  FIRSTNAME = 'FIRSTNAME',
  LASTNAME = 'LASTNAME',
}

export class ProfileFieldValidationInput {
  __typename?: 'ProfileFieldValidationInput' = 'ProfileFieldValidationInput';
  fieldName: ProfileFieldName;
  fieldValue: String;
}

export class ProfileFieldValidationResult {
  __typename?: 'ProfileFieldValidationResult' = 'ProfileFieldValidationResult';
  code: ProfileFieldValidationResultCode;
}

export enum ProfileFieldValidationResultCode {
  INTERNAL = 'INTERNAL',
  INVALID = 'INVALID',
  OK = 'OK',
}

export class ProfileUpdateInput {
  __typename?: 'ProfileUpdateInput' = 'ProfileUpdateInput';
  publicId?: Nullable<String>;
  trackId?: Nullable<String>;
}

export class ProfileUpdatePayload {
  __typename?: 'ProfileUpdatePayload' = 'ProfileUpdatePayload';
  query: Query = {};
}

export class ProfileUpdateProblem {
  __typename?: 'ProfileUpdateProblem' = 'ProfileUpdateProblem';
  reason: String;
}

export type ProfileUpdateResult = ProfileUpdatePayload | ProfileUpdateProblem;

export class PublicIdSuggestInput {
  __typename?: 'PublicIdSuggestInput' = 'PublicIdSuggestInput';
  firstName?: Nullable<String>;
  language?: Nullable<String>;
  lastName?: Nullable<String>;
  login?: Nullable<String>;
  trackId?: Nullable<String>;
}

export class PublicIdSuggestPayload {
  __typename?: 'PublicIdSuggestPayload' = 'PublicIdSuggestPayload';
  logins: Array<String>;
  trackId: String;
}

export class PublicIdSuggestProblem {
  __typename?: 'PublicIdSuggestProblem' = 'PublicIdSuggestProblem';
  reason: String;
}

export type PublicIdSuggestResult = PublicIdSuggestPayload | PublicIdSuggestProblem;

export class PublicIdUpdateInput {
  __typename?: 'PublicIdUpdateInput' = 'PublicIdUpdateInput';
  publicId: String;
  trackId?: Nullable<String>;
}

export class PublicIdUpdatePayload {
  __typename?: 'PublicIdUpdatePayload' = 'PublicIdUpdatePayload';
  query: Query = {};
}

export class PublicIdUpdateProblem {
  __typename?: 'PublicIdUpdateProblem' = 'PublicIdUpdateProblem';
  reason: String;
}

export type PublicIdUpdateResult = PublicIdUpdatePayload | PublicIdUpdateProblem;

export class PublicIdValidateInput {
  __typename?: 'PublicIdValidateInput' = 'PublicIdValidateInput';
  publicId: String;
  trackId?: Nullable<String>;
}

export class PublicIdValidatePayload {
  __typename?: 'PublicIdValidatePayload' = 'PublicIdValidatePayload';
  trackId: String;
}

export class PublicIdValidateProblem {
  __typename?: 'PublicIdValidateProblem' = 'PublicIdValidateProblem';
  reason: String;
}

export type PublicIdValidateResult = PublicIdValidatePayload | PublicIdValidateProblem;

export class Query {
  __typename?: 'Query' = 'Query';
}

export class Question {
  __typename?: 'Question' = 'Question';
  id: ID;
  text: String;
}

export class Receipt {
  __typename?: 'Receipt' = 'Receipt';
  amount?: Nullable<Array<Float>>;
  timestamp?: Nullable<String>;
  type?: Nullable<String>;
  url: String;
}

export class RemoveRecoveryEmailInput {
  __typename?: 'RemoveRecoveryEmailInput' = 'RemoveRecoveryEmailInput';
  email: String;
  trackId?: Nullable<String>;
}

export class RemoveRecoveryEmailPayload {
  __typename?: 'RemoveRecoveryEmailPayload' = 'RemoveRecoveryEmailPayload';
  query: Query = {};
}

export class RemoveRecoveryEmailProblem {
  __typename?: 'RemoveRecoveryEmailProblem' = 'RemoveRecoveryEmailProblem';
  reason: RemoveRecoveryEmailProblemKind;
  trackId: String;
}

export enum RemoveRecoveryEmailProblemKind {
  INTERNAL = 'INTERNAL',
  PASSWORD_REQUIRED = 'PASSWORD_REQUIRED',
}

export type RemoveRecoveryEmailResult = RemoveRecoveryEmailPayload | RemoveRecoveryEmailProblem;

export class Restriction {
  __typename?: 'Restriction' = 'Restriction';
  allowAllServices: Boolean;
  balance: Int;
  enabled: Boolean;
  hasSecurePhone: Boolean;
  limit: Limit;
  limitCurrency: String;
  uid: String;
  unlim: Boolean;
}

export class SendCodeToBindPrimaryPhoneInput {
  __typename?: 'SendCodeToBindPrimaryPhoneInput' = 'SendCodeToBindPrimaryPhoneInput';
  number: String;
  trackId?: Nullable<String>;
}

export class SendCodeToBindPrimaryPhonePayload {
  __typename?: 'SendCodeToBindPrimaryPhonePayload' = 'SendCodeToBindPrimaryPhonePayload';
  expiryTimestamp: Timestamp;
  number: String;
  trackId: String;
}

export class SendCodeToBindPrimaryPhoneProblem {
  __typename?: 'SendCodeToBindPrimaryPhoneProblem' = 'SendCodeToBindPrimaryPhoneProblem';
  reason: SendCodeToBindPrimaryPhoneProblemReason;
}

export enum SendCodeToBindPrimaryPhoneProblemReason {
  INTERNAL = 'INTERNAL',
  PHONE_NUMBER_BLOCKED = 'PHONE_NUMBER_BLOCKED',
  PHONE_NUMBER_INVALID = 'PHONE_NUMBER_INVALID',
  SMS_LIMIT_EXCEEDED = 'SMS_LIMIT_EXCEEDED',
}

export type SendCodeToBindPrimaryPhoneResult =
  | SendCodeToBindPrimaryPhonePayload
  | SendCodeToBindPrimaryPhoneProblem;

export class SendCodeToConfirmPhoneInput {
  __typename?: 'SendCodeToConfirmPhoneInput' = 'SendCodeToConfirmPhoneInput';
  number: String;
  trackId?: Nullable<String>;
}

export class SendCodeToConfirmPhonePayload {
  __typename?: 'SendCodeToConfirmPhonePayload' = 'SendCodeToConfirmPhonePayload';
  expiryTimestamp: Timestamp;
  number: String;
  trackId: String;
}

export class SendCodeToConfirmPhoneProblem {
  __typename?: 'SendCodeToConfirmPhoneProblem' = 'SendCodeToConfirmPhoneProblem';
  reason: SendCodeToConfirmPhoneProblemReason;
}

export enum SendCodeToConfirmPhoneProblemReason {
  INTERNAL = 'INTERNAL',
  PHONE_NUMBER_BLOCKED = 'PHONE_NUMBER_BLOCKED',
  PHONE_NUMBER_INVALID = 'PHONE_NUMBER_INVALID',
  SMS_LIMIT_EXCEEDED = 'SMS_LIMIT_EXCEEDED',
}

export type SendCodeToConfirmPhoneResult =
  | SendCodeToConfirmPhonePayload
  | SendCodeToConfirmPhoneProblem;

export class Service {
  __typename?: 'Service' = 'Service';
  help?: Nullable<String>;
  i18nKeyName?: Nullable<String>;
  iconUrl: String;
  id: String;
  name: String;
  splashUrl?: Nullable<String>;
  url?: Nullable<String>;
}

export class SetQuestionInput {
  __typename?: 'SetQuestionInput' = 'SetQuestionInput';
  newAnswer: String;
  newQuestion: String;
  oldAnswer: String;
  questionId: String;
  trackId?: Nullable<String>;
}

export class SetQuestionPayload {
  __typename?: 'SetQuestionPayload' = 'SetQuestionPayload';
  query: Query = {};
}

export class SetQuestionProblem {
  __typename?: 'SetQuestionProblem' = 'SetQuestionProblem';
  reason: SetQuestionProblemKind;
  trackId: String;
}

export enum SetQuestionProblemKind {
  COMPARE_NOT_MATCHED = 'COMPARE_NOT_MATCHED',
  INTERNAL = 'INTERNAL',
  PASSWORD_REQUIRED = 'PASSWORD_REQUIRED',
}

export type SetQuestionResult = SetQuestionPayload | SetQuestionProblem;

export class SnilsDocument implements IDocument {
  __typename?: 'SnilsDocument' = 'SnilsDocument';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class StartOrderBillInput {
  __typename?: 'StartOrderBillInput' = 'StartOrderBillInput';
  id: String;
  mpi_3ds_info: ClientMpiInfoInput;
  payer_full_name: String;
  payment_method: String;
  payment_token: String;
  return_url: String;
}

export class StartOrderBillResponse {
  __typename?: 'StartOrderBillResponse' = 'StartOrderBillResponse';
  transaction: Trancsaction;
}

export type Timestamp = Date;

export class TimezoneOption {
  __typename?: 'TimezoneOption' = 'TimezoneOption';
  code: String;
  name: String;
}

export class ToggleLoginWithExternalAccountInput {
  __typename?: 'ToggleLoginWithExternalAccountInput' = 'ToggleLoginWithExternalAccountInput';
  enabled: Boolean;
  id: ID;
}

export class ToggleLoginWithExternalAccountPayload {
  __typename?: 'ToggleLoginWithExternalAccountPayload' = 'ToggleLoginWithExternalAccountPayload';
  query: Query = {};
}

export class ToggleLoginWithExternalAccountProblem {
  __typename?: 'ToggleLoginWithExternalAccountProblem' = 'ToggleLoginWithExternalAccountProblem';
  reason: ToggleLoginWithExternalAccountReason;
}

export enum ToggleLoginWithExternalAccountReason {
  INTERNAL = 'INTERNAL',
}

export type ToggleLoginWithExternalAccountResult =
  | ToggleLoginWithExternalAccountPayload
  | ToggleLoginWithExternalAccountProblem;

export class ToggleLoginWithPasswordAndSmsInput {
  __typename?: 'ToggleLoginWithPasswordAndSmsInput' = 'ToggleLoginWithPasswordAndSmsInput';
  trackId: String;
}

export class ToggleLoginWithPasswordAndSmsPayload {
  __typename?: 'ToggleLoginWithPasswordAndSmsPayload' = 'ToggleLoginWithPasswordAndSmsPayload';
  account: Account;
}

export class ToggleLoginWithPasswordAndSmsProblem {
  __typename?: 'ToggleLoginWithPasswordAndSmsProblem' = 'ToggleLoginWithPasswordAndSmsProblem';
  reason: ToggleLoginWithPasswordAndSmsProblemReason;
}

export enum ToggleLoginWithPasswordAndSmsProblemReason {
  INTERNAL = 'INTERNAL',
  PRIMARY_PHONE_NOT_BOUND = 'PRIMARY_PHONE_NOT_BOUND',
  PRIMARY_PHONE_NOT_CONFIRMED = 'PRIMARY_PHONE_NOT_CONFIRMED',
  TRACK_ID_INVALID = 'TRACK_ID_INVALID',
  TRACK_INVALID_STATE = 'TRACK_INVALID_STATE',
}

export type ToggleLoginWithPasswordAndSmsResult =
  | ToggleLoginWithPasswordAndSmsPayload
  | ToggleLoginWithPasswordAndSmsProblem;

export class Trancsaction {
  __typename?: 'Trancsaction' = 'Trancsaction';
  acs_url: String;
  amount: Int;
  created: String;
  mpi_3ds_info: Mpi3dsInfo;
  order_id: String;
  payer_full_name: String;
  payment_method: String;
  payment_token: String;
  return_url: String;
  status: TransactionStatus;
  transaction_id: String;
  updated: String;
}

export enum TransactionStatus {
  CANCELLED = 'CANCELLED',
  NEW = 'NEW',
  PAID = 'PAID',
  REFUNDED = 'REFUNDED',
}

export class UnbindExternalAccountInput {
  __typename?: 'UnbindExternalAccountInput' = 'UnbindExternalAccountInput';
  id: ID;
}

export class UnbindExternalAccountPayload {
  __typename?: 'UnbindExternalAccountPayload' = 'UnbindExternalAccountPayload';
  query: Query = {};
}

export class UnbindExternalAccountProblem {
  __typename?: 'UnbindExternalAccountProblem' = 'UnbindExternalAccountProblem';
  reason: UnbindExternalAccountReason;
}

export enum UnbindExternalAccountReason {
  INTERNAL = 'INTERNAL',
}

export type UnbindExternalAccountResult =
  | UnbindExternalAccountPayload
  | UnbindExternalAccountProblem;

export class UpdateBillsDocumentInput {
  __typename?: 'UpdateBillsDocumentInput' = 'UpdateBillsDocumentInput';
  id: String;
  title: String;
  type: String;
  value: String;
}

export class UpdateBirthCertificateInput {
  __typename?: 'UpdateBirthCertificateInput' = 'UpdateBirthCertificateInput';
  birthAkt?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  fatherBirthDate?: Nullable<String>;
  fatherCitizenship?: Nullable<String>;
  fatherFirstName?: Nullable<String>;
  fatherLastName?: Nullable<String>;
  fatherMiddleName?: Nullable<String>;
  fatherNationality?: Nullable<String>;
  firstName?: Nullable<String>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuePlace?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  motherBirthDate?: Nullable<String>;
  motherCitizenship?: Nullable<String>;
  motherFirstName?: Nullable<String>;
  motherLastName?: Nullable<String>;
  motherMiddleName?: Nullable<String>;
  motherNationality?: Nullable<String>;
  registrationPlace?: Nullable<String>;
  series?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateDocumentInput {
  __typename?: 'UpdateDocumentInput' = 'UpdateDocumentInput';
  birthCertificateInput?: Nullable<UpdateBirthCertificateInput>;
  driverLicenseInput?: Nullable<UpdateDriverLicenseInput>;
  innInput?: Nullable<UpdateInnInput>;
  internationalIdInput?: Nullable<UpdateInternationalIdInput>;
  medicalInsuranceInput?: Nullable<UpdateMedicalInsuranceInput>;
  nationalIdInput?: Nullable<UpdateNationalIdInput>;
  snilsInput?: Nullable<UpdateSnilsInput>;
  type: DocumentType;
  vehicleRegistrationCertificateInput?: Nullable<UpdateVehicleRegistrationCertificateInput>;
  voluntaryMedicalInsuranceInput?: Nullable<UpdateVoluntaryMedicalInsuranceInput>;
}

export class UpdateDocumentPayload {
  __typename?: 'UpdateDocumentPayload' = 'UpdateDocumentPayload';
  query: Query = {};
}

export class UpdateDocumentProblem {
  __typename?: 'UpdateDocumentProblem' = 'UpdateDocumentProblem';
  reason: UpdateDocumentProblemReason;
}

export enum UpdateDocumentProblemReason {
  INTERNAL = 'INTERNAL',
}

export type UpdateDocumentResult = UpdateDocumentPayload | UpdateDocumentProblem;

export class UpdateDriverLicenseInput {
  __typename?: 'UpdateDriverLicenseInput' = 'UpdateDriverLicenseInput';
  additionalInformation?: Nullable<String>;
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  category?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuedByLat?: Nullable<String>;
  issuedCity?: Nullable<String>;
  issuedCityLat?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  middleName?: Nullable<String>;
  middleNameLat?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateInnInput {
  __typename?: 'UpdateInnInput' = 'UpdateInnInput';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateInternationalIdInput {
  __typename?: 'UpdateInternationalIdInput' = 'UpdateInternationalIdInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  birthPlaceLat?: Nullable<String>;
  citizenship?: Nullable<String>;
  citizenshipLat?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateMedicalInsuranceInput {
  __typename?: 'UpdateMedicalInsuranceInput' = 'UpdateMedicalInsuranceInput';
  birthDate?: Nullable<String>;
  blank?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateNationalIdInput {
  __typename?: 'UpdateNationalIdInput' = 'UpdateNationalIdInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuedBy?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  registrationAddress?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdatePersonalInfoInput {
  __typename?: 'UpdatePersonalInfoInput' = 'UpdatePersonalInfoInput';
  birthday?: Nullable<String>;
  city?: Nullable<String>;
  country: String;
  deleteAvatar?: Nullable<Boolean>;
  displayName: String;
  firstname: String;
  gender: String;
  lastname: String;
  timezone: String;
}

export class UpdatePersonalInfoPayload {
  __typename?: 'UpdatePersonalInfoPayload' = 'UpdatePersonalInfoPayload';
  query: Query = {};
}

export class UpdatePersonalInfoProblem {
  __typename?: 'UpdatePersonalInfoProblem' = 'UpdatePersonalInfoProblem';
  reason: UpdatePersonalInfoProblemKind;
}

export enum UpdatePersonalInfoProblemKind {
  DELETE_AVATAR_INTERNAL = 'DELETE_AVATAR_INTERNAL',
  UPDATE_DATA_INTERNAL = 'UPDATE_DATA_INTERNAL',
}

export type UpdatePersonalInfoResult = UpdatePersonalInfoPayload | UpdatePersonalInfoProblem;

export class UpdateSnilsInput {
  __typename?: 'UpdateSnilsInput' = 'UpdateSnilsInput';
  birthDate?: Nullable<String>;
  birthPlace?: Nullable<String>;
  docNumber?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class UpdateVehicleRegistrationCertificateInput {
  __typename?: 'UpdateVehicleRegistrationCertificateInput' =
    'UpdateVehicleRegistrationCertificateInput';
  additionalInformation?: Nullable<String>;
  bodyNumber?: Nullable<String>;
  carNumber?: Nullable<String>;
  category?: Nullable<String>;
  color?: Nullable<String>;
  docNumber?: Nullable<String>;
  ecoClass?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  id: ID;
  images: Array<DocumentImageInput>;
  issueDate?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  maxWeight?: Nullable<String>;
  middleName?: Nullable<String>;
  model?: Nullable<String>;
  modelLat?: Nullable<String>;
  power?: Nullable<String>;
  pts?: Nullable<String>;
  registrationAddress?: Nullable<String>;
  shasiNumber?: Nullable<String>;
  temporaryReg?: Nullable<String>;
  vehicleType?: Nullable<String>;
  verificationStatus?: Nullable<String>;
  vin?: Nullable<String>;
  withoutLoadWeight?: Nullable<String>;
  year?: Nullable<String>;
}

export class UpdateVoluntaryMedicalInsuranceInput {
  __typename?: 'UpdateVoluntaryMedicalInsuranceInput' = 'UpdateVoluntaryMedicalInsuranceInput';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImageInput>;
  insurerOrg?: Nullable<String>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  verificationStatus?: Nullable<String>;
}

export class VehicleRegistrationCertificateDocument implements IDocument {
  __typename?: 'VehicleRegistrationCertificateDocument' = 'VehicleRegistrationCertificateDocument';
  additionalInformation?: Nullable<String>;
  bodyNumber?: Nullable<String>;
  carNumber?: Nullable<String>;
  category?: Nullable<String>;
  color?: Nullable<String>;
  docNumber?: Nullable<String>;
  ecoClass?: Nullable<String>;
  firstName?: Nullable<String>;
  firstNameLat?: Nullable<String>;
  id: ID;
  images: Array<DocumentImage>;
  issueDate?: Nullable<String>;
  issuerSubdivisionCode?: Nullable<String>;
  lastName?: Nullable<String>;
  lastNameLat?: Nullable<String>;
  maxWeight?: Nullable<String>;
  middleName?: Nullable<String>;
  model?: Nullable<String>;
  modelLat?: Nullable<String>;
  originalUrl?: Nullable<String>;
  power?: Nullable<String>;
  previewUrl?: Nullable<String>;
  pts?: Nullable<String>;
  registrationAddress?: Nullable<String>;
  section: DocumentSection;
  shasiNumber?: Nullable<String>;
  temporaryReg?: Nullable<String>;
  type: DocumentType;
  vehicleType?: Nullable<String>;
  verificationStatus?: Nullable<String>;
  vin?: Nullable<String>;
  withoutLoadWeight?: Nullable<String>;
  year?: Nullable<String>;
}

export class VerifyCodeToBindPrimaryPhoneInput {
  __typename?: 'VerifyCodeToBindPrimaryPhoneInput' = 'VerifyCodeToBindPrimaryPhoneInput';
  code: String;
  trackId: String;
}

export class VerifyCodeToBindPrimaryPhonePayload {
  __typename?: 'VerifyCodeToBindPrimaryPhonePayload' = 'VerifyCodeToBindPrimaryPhonePayload';
  query: Query = {};
  trackId: String;
}

export class VerifyCodeToBindPrimaryPhoneProblem {
  __typename?: 'VerifyCodeToBindPrimaryPhoneProblem' = 'VerifyCodeToBindPrimaryPhoneProblem';
  reason: VerifyCodeToBindPrimaryPhoneProblemReason;
}

export enum VerifyCodeToBindPrimaryPhoneProblemReason {
  CODE_EMPTY = 'CODE_EMPTY',
  CODE_INVALID = 'CODE_INVALID',
  CODE_NOT_SENT = 'CODE_NOT_SENT',
  CONFIRMATIONS_LIMIT_EXCEEDED = 'CONFIRMATIONS_LIMIT_EXCEEDED',
  INTERNAL = 'INTERNAL',
  TRACK_ID_INVALID = 'TRACK_ID_INVALID',
}

export type VerifyCodeToBindPrimaryPhoneResult =
  | VerifyCodeToBindPrimaryPhonePayload
  | VerifyCodeToBindPrimaryPhoneProblem;

export class VerifyCodeToConfirmPhoneInput {
  __typename?: 'VerifyCodeToConfirmPhoneInput' = 'VerifyCodeToConfirmPhoneInput';
  code: String;
  trackId: String;
}

export class VerifyCodeToConfirmPhonePayload {
  __typename?: 'VerifyCodeToConfirmPhonePayload' = 'VerifyCodeToConfirmPhonePayload';
  trackId: String;
}

export class VerifyCodeToConfirmPhoneProblem {
  __typename?: 'VerifyCodeToConfirmPhoneProblem' = 'VerifyCodeToConfirmPhoneProblem';
  reason: VerifyCodeToConfirmPhoneProblemReason;
}

export enum VerifyCodeToConfirmPhoneProblemReason {
  CODE_INVALID = 'CODE_INVALID',
  CODE_NOT_SENT = 'CODE_NOT_SENT',
  CONFIRMATIONS_LIMIT_EXCEEDED = 'CONFIRMATIONS_LIMIT_EXCEEDED',
  INTERNAL = 'INTERNAL',
  TRACK_ID_INVALID = 'TRACK_ID_INVALID',
}

export type VerifyCodeToConfirmPhoneResult =
  | VerifyCodeToConfirmPhonePayload
  | VerifyCodeToConfirmPhoneProblem;

export class Viewer {
  __typename?: 'Viewer' = 'Viewer';
  avatarId: String;
  birthdate?: Nullable<String>;
  city?: Nullable<String>;
  country: String;
  displayName: String;
  firstName?: Nullable<String>;
  fullName?: Nullable<String>;
  gender: String;
  hasFamilyPlus: Boolean;
  hasPublicIdSet?: Nullable<Boolean>;
  havePlus: Boolean;
  id: ID;
  isChild: Boolean;
  lastName?: Nullable<String>;
  publicId?: Nullable<String>;
  timezone: String;
}

export class VoluntaryMedicalInsuranceDocument implements IDocument {
  __typename?: 'VoluntaryMedicalInsuranceDocument' = 'VoluntaryMedicalInsuranceDocument';
  birthDate?: Nullable<String>;
  docNumber?: Nullable<String>;
  endDate?: Nullable<String>;
  firstName?: Nullable<String>;
  gender?: Nullable<DocumentGender>;
  id: ID;
  images: Array<DocumentImage>;
  insurerOrg?: Nullable<String>;
  issueDate?: Nullable<String>;
  lastName?: Nullable<String>;
  middleName?: Nullable<String>;
  originalUrl?: Nullable<String>;
  previewUrl?: Nullable<String>;
  section: DocumentSection;
  type: DocumentType;
  verificationStatus?: Nullable<String>;
}

export class getTransactionInput {
  __typename?: 'getTransactionInput' = 'getTransactionInput';
  id: String;
}
