import { ApolloError } from 'apollo-server-express';
import { GraphQLError } from 'graphql';

import { getYEnv } from '@server/config';
import { staticLogger } from '@server/shared/logger';

export const formatError = (error: GraphQLError) => {
  const yenv = getYEnv();

  staticLogger.error('Graphql Error Formatter', error);

  if (yenv === 'development' || yenv === 'testing') {
    return error;
  }

  // Nest Graphql уже обернул ошибку, если она не обёрнута вручную.
  if (error instanceof ApolloError) {
    // Если обёрнута автоматически, то code = INTERNAL_SERVER_ERROR, поэтому только вырезаем кишки ошибки
    if (error.extensions.code && error.extensions.code === 'INTERNAL_SERVER_ERROR') {
      delete error.extensions.exception;
    }

    // Если обёрнута вручную, то просто возвращаем.
    return error;
  }

  // Маловероятный случай. fallback, если по какой-то причине ошибка не обёрнута.
  return new ApolloError(error.message, 'INTERNAL_SERVER_ERROR');
};
