import { ApolloDriver, ApolloDriverConfig } from '@nestjs/apollo';
import { Module } from '@nestjs/common';
import { GraphQLModule as BaseGraphQLModule, GraphQLTimestamp } from '@nestjs/graphql';
import { isDevMode } from '@server/config';

import { formatError } from './errors';

@Module({
  imports: [
    BaseGraphQLModule.forRoot<ApolloDriverConfig>({
      driver: ApolloDriver,
      path: '/security/graphql',
      typePaths: ['./**/*.graphql'],
      playground: isDevMode,
      resolvers: {
        Timestamp: GraphQLTimestamp,
      },
      formatError,
    }),
  ],
  exports: [BaseGraphQLModule],
})
export class GraphqlModule {}
