import { GraphQLResolveInfo, OperationTypeNode } from 'graphql';

import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { GqlContextType, GqlExecutionContext } from '@nestjs/graphql';
import { isDevMode } from '@server/config';
import { CSRFException, SecretkeyService } from '@yandex-int/nest-infra';

@Injectable()
export class SecretKeyGuard implements CanActivate {
  constructor(private secretkeyService: SecretkeyService) {}

  async canActivate(context: ExecutionContext): Promise<boolean> {
    const operationType = this.getGraphQLOperation(context);

    if (!isDevMode && operationType === OperationTypeNode.MUTATION) {
      const valid = await this.secretkeyService.validate();

      if (!valid) {
        throw new CSRFException();
      }
    }

    return true;
  }

  private getGraphQLOperation(context: ExecutionContext) {
    if (context.getType<GqlContextType>() === 'graphql') {
      const gqlContext = GqlExecutionContext.create(context);
      const info = gqlContext.getInfo<GraphQLResolveInfo>();

      return info.operation.operation;
    }

    return null;
  }
}
