import fs from 'fs';
import { createRequire } from 'module';

import { NestApplicationOptions } from '@nestjs/common';
import { staticLogger } from '@server/shared/logger';

import { bootstrap } from './bootstrap';
import { getPort, isDevMode } from './config';
import { preloadAllPagesComponents } from './shared/modules-preloader';

async function main() {
  const options: NestApplicationOptions = {};

  if (isDevMode) {
    const nativeRequire = createRequire(__dirname);
    const certPath = nativeRequire.resolve('@yandex-int/magicdev/data/yandex.pem');
    const certContent = fs.readFileSync(certPath);

    options.httpsOptions = {
      key: certContent,
      cert: certContent,
    };
  }

  const app = await bootstrap(options);

  if (!isDevMode) {
    await preloadAllPagesComponents();
  }

  // TODO: жуткий временный костыль (tm): порт должен быть в конфиге, а не захардкоджен
  await app.listen(getPort(), () => {
    if (isDevMode) {
      staticLogger.log(`Start server on https://localhost.msup.yandex.ru`);
    }
  });

  module.hot?.dispose(() => {
    staticLogger.log(`Restarting server...`);

    return app.close();
  });
}

main();

module.hot?.accept();
