import { Controller, Get, Param, Render, UseInterceptors } from '@nestjs/common';
import { AccountActionsService } from '@server/features/account-actions';
import { ParamsInterceptor } from '@server/shared/interceptors';
import { LangDetect } from '@server/shared/lang-detect';
import { LoggerService } from '@server/shared/logger';

@Controller()
@UseInterceptors(ParamsInterceptor)
export class PagesController {
  constructor(
    private accountActionsService: AccountActionsService,
    private logger: LoggerService,
  ) {}

  @Get('')
  @Render('index')
  index() {
    return {};
  }

  @Get('family')
  @Render('family')
  family() {
    return {};
  }

  @Get('iframe/documents')
  @Render('iframe/documents')
  async iframeDocuments() {
    return {};
  }

  @Get('iframe/payments')
  @Render('iframe/payments')
  async iframePayments() {
    return {};
  }

  @Get('helpdesk/:guid?/:timestamp?')
  @Render('helpdesk')
  async helpdesk(@Param('guid') guid?: string) {
    return { guid };
  }

  @Get('personal')
  @Render('personal')
  async personal() {
    return {};
  }

  @Get('personal/documents')
  @Render('personal/documents')
  async personalDocuments() {
    return {};
  }

  @Get('personal/addresses')
  @Render('personal/addresses')
  async personalAddresses() {
    return {};
  }

  @Get('personal/contacts')
  @Render('personal/contacts')
  async personalContacts() {
    return {};
  }

  @Get('personal/passwords')
  @Render('personal/passwords')
  async passwords() {
    return {};
  }

  @Get('personal/bonus')
  @Render('personal/bonus')
  async personalBonus() {
    return {};
  }

  @Get('pay')
  @Render('pay')
  async pay() {
    return {};
  }

  @Get('pay/history')
  @Render('pay/history')
  async payHistory() {
    return {};
  }

  @Get('pay/history/receipts')
  @Render('pay/history/receipts')
  async payReceipts() {
    return { tab: 'receipts' };
  }

  @Get('pay/gibdd')
  @Render('pay/gibdd')
  async payGibdd() {
    return {};
  }

  @Get('pay/gibdd/settings')
  @Render('pay/gibdd/settings')
  async payGibddSettings() {
    return {};
  }

  @Get('pay/gibdd/settings/documents/add-vrc')
  @Render('pay/gibdd/settings/documents/add-vrc')
  async payGibddSettingsDocumentVrc() {
    return {};
  }

  @Get('pay/gibdd/settings/documents/add-dl')
  @Render('pay/gibdd/settings/documents/add-dl')
  async payGibddSettingsDocumentDl() {
    return {};
  }

  @Get('pay/gibdd/settings/documents/:id?')
  @Render('pay/gibdd/settings/documents/[id]')
  async payGibddSettingsDocument() {
    return {};
  }

  @Get('/iframe/gibdd')
  @Render('/iframe/gibdd')
  async iframeGibdd() {
    return {};
  }

  @Get('/iframe/gibdd/settings')
  @Render('/iframe/gibdd/settings')
  async iframeGibddSettings() {
    return {};
  }

  @Get('/iframe/gibdd/settings/documents/add-vrc')
  @Render('/iframe/gibdd/settings/documents/add-vrc')
  async iframeGibddSettingsDocumentVrc() {
    return {};
  }

  @Get('/iframe/gibdd/settings/documents/add-dl')
  @Render('/iframe/gibdd/settings/documents/add-dl')
  async iframeGibddSettingsDocumentDl() {
    return {};
  }

  @Get('/iframe/gibdd/settings/documents/:id?')
  @Render('/iframe/gibdd/settings/documents/[id]')
  async iframeGibddSettingsDocument() {
    return {};
  }

  @Get('security')
  @Render('security')
  security() {
    return {};
  }

  @Get('security/enter-methods')
  @Render('security/enter-methods')
  securityEnterMethods() {
    return {};
  }

  @Get('security/activity')
  @Render('security/activity')
  async securityActivity(@LangDetect('id') lang: string) {
    const accountActions = await this.getAccountActions(lang);

    return {
      accountActions,
    };
  }

  @Get('security/external-accounts')
  @Render('security/external-accounts')
  securityExternalAccounts() {
    return {};
  }

  @Get('/security/api/account/actions')
  async getAccountActions(@LangDetect('id') lang: string) {
    try {
      const data = await this.accountActionsService.getActions(180, lang);

      return { data, status: 'success' };
    } catch (err) {
      this.logger.error('Fail /api/account/actions', err);

      return { status: 'failed' };
    }
  }

  @Get('security/oauth/bind-external-account')
  @Render('security/oauth/bind-external-account')
  oauthBindExternalAccount() {
    return {};
  }
}
