export const BLACKBOX_ALIASES = {
  /**
   * Алиас портального аккаунта.
   * Может использоваться в любом контексте, где требуется логин пользователя.
   */
  portal: '1',

  /**
   * Почтовый алиас.
   * Используется пользователями, у которых адрес почтового ящика не совпадает с портальным алиасом.
   * Используется при доставке почты или поиске по e-mail.
   * Аккаунты с данным алиасом также обязательно имеют портальный алиас.
   */
  mail: '2',

  /**
   * Алиас почты на Народе, если он не совпадает с портальным алиасом.
   * Аккаунты с данным алиасом также обязательно имеют портальный алиас.
   */
  narodmail: '3',

  /**
   * Лайт-пользователь.
   * В алиасе хранится подтвержденный e-mail стороннего сервиса.
   */
  lite: '5',

  /**
   * Социальный аккаунт.
   * В алиасе хранится сгенерированный идентификатор, недоступный пользователю.
   * Аккаунт может быть дорегистрирован и иметь портальный алиас.
   */
  social: '6',

  /**
   * Пользователь Почты Для Домена.
   * Хранит информацию о пользователе в формате `пользователь@домен`.
   * Доменная часть идентификатора может меняться при редактировании имени домена.
   */
  pdd: '7',

  /**
   * Алиасы ПДД-пользователя.
   * Пользователь ПДД может иметь несколько алиасов.
   */
  pddalias: '8',

  /**
   * Аккаунты в альтернативных доменах, принадлежащих Яндексу.
   * Аналогичен алиасу ПДД.
   */
  altdomain: '9',

  /**
   * Алиас телефонного аккаунта.
   * Не рекомендуется использовать из-за сложностей с переходом телефонного номера от одного владельца другому.
   */
  phonish: '10',

  /**
   * Телефонный алиас.
   * Обеспечивает поиск по телефонному номеру, уникальному для портального аккаунта.
   */
  phonenumber: '11',

  /**
   * Технический алиас для сбора почты со сторонних почтовых сервисов.
   */
  mailish: '12',

  /**
   * Логин сотрудника Яндекса, подтвердившего свой аккаунт на Стаффе.
   * Наличие алиаса является признаком сотрудника.
   */
  yandexoid: '13',

  /**
   * Технический алиас, содержащий идентификатор аккаунта Кинопоиска.
   */
  kinopoisk: '15',

  /**
   * Технический алиас, содержащий идентификатор аккаунта Uber.
   */
  uber: '16',

  /**
   * Технический алиас для идентификации ботов или каналов нового мессенджера.
   */
  yambot: '17',

  /**
   * Технический алиас для идентификации пользователей Яндекс.Станции.
   */
  kolonkish: '18',

  /**
   * Выставленный вручную public_id
   */
  public_id: '19',

  /**
   * Предыдущие значения алиаса public_id
   */
  old_public_id: '20',

  /**
   * Синтетический алиас для неофонишей
   */
  neophonish: '21',

  /**
   * Синтетический алиас для ребёнкишей
   */
  kiddish: '22',

  /**
   * Алиас для учеников
   */
  scholar: '23',

  /**
   * SAML
   */
  federal: '24',

  /**
   * Банковский номер телефона
   */
  bank_phonenumber: '25',
} as const;
