export const BLACKBOX_ATTRIBUTES = {
  /**
   * Дата и время регистрации пользователя, unixtime.
   */
  'account.registration_datetime': '1',

  /**
   * Признак того, что у пользователя есть [платежный пароль](https://yandex.ru/support/money/password/permanent.html).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.have_pay_password': '5',

  /**
   * Признак того, что пользователь принял соглашение ПДД.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_pdd_agreement_accepted': '6',

  /**
   * Признак того, что пользователь является администратором ПДД домена.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_pdd_admin': '7',

  /**
   * Признак того, что пользователь является бета-тестером.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_betatester': '8',

  /**
   * Признак того, что данный аккаунт создан яндексоидом и используется для корпоративных нужд.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_corporate': '9',

  /**
   * Признак VIP-аккаунта. В данный момент не используется.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_vip': '10',

  /**
   * Признак того, что пользователь является сотрудником Яндекса или роботным аккаунтом.
   * Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_employee': '12',

  /**
   * Признак того, что аккаунт является почтовой рассылкой.
   * Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_maillist': '13',

  'account.has_custom_public_id': '1024',

  /**
   * Контактный номер телефона.
   * Требует гранта ЧЯ.
   */
  'person.contact_phone_number': '15',

  /**
   * Дата и время обновления пароля.
   * Поле присутствует у всех пользователей, для которых не включена двухфакторная аутентификация.
   */
  'password.update_datetime': '20',

  /**
   * Качество пароля пользователя.
   * Требует гранта ЧЯ.
   */
  'password.quality': '21',

  /**
   * Причина, по которой пользователю требуется изменить пароль.
   * Возможные значения:
   *  - 1 — подозрение на взлом аккаунта.
   *  - 2 — пароль был сброшен пользователем.
   */
  'password.forced_changing_reason': '22',

  /**
   * Признак того, что пользователю потребуется создать пароль.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'password.is_creating_required': '23',

  /**
   * Признак того, что пароль пользователя защищен дополнительными требованиями на сложность.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_strong_password_required': '24',

  /**
   * Имя пользователя.
   * Требует гранта ЧЯ.
   */
  'person.firstname': '27',

  /**
   * Фамилия пользователя.
   * Требует гранта ЧЯ.
   */
  'person.lastname': '28',

  /**
   * Пол пользователя. Возможные значения:
   * - `m` — мужчина.
   * - `f` — женщина.
   * - атрибут отсутствует — пол не указан.
   * Требует гранта ЧЯ.
   */
  'person.gender': '29',

  /**
   * День рождения пользователя, дата.
   * Требует гранта ЧЯ.
   */
  'person.birthdate': '30',

  /**
   * Страна проживания пользователя.
   */
  'person.country': '31',

  /**
   * Город проживания пользователя.
   */
  'person.city': '32',

  /**
   * Часовой пояс пользователя.
   */
  'person.timezone': '33',

  /**
   * Язык интерфейса для пользователя.
   */
  'person.language': '34',

  /**
   * Признак подписки пользователя на Яндекс.Новости.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.news': '46',

  /**
   * Признак подписки пользователя на Директ.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.direct': '48',

  /**
   * Признак подписки пользователя на Спамоборону.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.spamooborona': '49',

  /**
   * Признак подписки пользователя на Баланс-Биллинг.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.balance': '50',

  /**
   * Признак подписки пользователя на Яндекс.Деньги.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.money.login_rule': '51',

  /**
   * Признак подписки пользователя на [Ленту](https://ru.wikipedia.org/wiki/Яндекс.Лента).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.23': '52',

  /**
   * Признак подписки пользователя на РСЯ.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.24': '53',

  /**
   * Признак подписки пользователя на Маркет.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.25': '54',

  /**
   * Признак подписки пользователя на [Телепрограмму](https://tv.yandex.ru).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.29': '57',

  /**
   * Признак подписки пользователя на Яндекс.Афишу.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.30': '58',

  /**
   * Признак подписки пользователя на Яндекс.Календарь.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.31': '59',

  /**
   * Признак подписки пользователя на Видеохостинг.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.39': '62',

  /**
   * Настройки виджетной морды пользователя.
   */
  'subscription.wwwdgt.mode': '65',

  /**
   * Признак подписки пользователя на Народный диск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.disk.login_rule': '66',

  /**
   * Признак подписки пользователя на Народ 2.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.narod2.login_rule': '67',

  /**
   * Признак подписки пользователя на Яндекс.Вебмастер.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.47': '68',

  /**
   * Признак подписки пользователя на Яндекс.Метрику.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.48': '69',

  /**
   * Признак подписки пользователя на Яндекс.Карты.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.49': '70',

  /**
   * Признак подписки пользователя на Яндекс.Музыку для партнеров.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.50': '71',

  /**
   * Признак подписки пользователя на [Яндекс.Радиосводки](http://radioprobki.yandex.ru).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.51': '72',

  /**
   * Признак подписки пользователя на [Народную Карту](https://n.maps.yandex.ru/).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.52': '73',

  /**
   * Признак подписки пользователя на [Яндекс.XML](https://xml.yandex.ru/settings/).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.53': '74',

  /**
   * Признак подписки пользователя на Яндекс.Музыку.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.54': '75',

  /**
   * Признак подписки пользователя на Мобильную почту.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.55': '76',

  /**
   * Признак подписки пользователя на [Кабинет разработчиков виджетов](https://wdgt.yandex.ru/widgets/).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.57': '77',

  /**
   * Признак подписки пользователя на Яндекс.Диск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.is_active': '78',

  /**
   * Признак подписки пользователя на Партнерский интерфейс Новостей.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.60': '79',

  /**
   * Признак того, что у пользователя оплачен Яндекс.Диск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.is_paid': '80',

  /**
   * Признак пользователя мобильного Яндекс.Диска.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.use_mobile': '82',

  /**
   * Признак подписки пользователя на мобильную Яндекс.Музыку.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.78': '83',

  /**
   * Признак пользователя десктопного Яндекс.Диска.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.use_desktop': '84',

  /**
   * Признак пользователя веб-версии Яндекс.Диска.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.use_web': '85',

  /**
   * Признак подписки пользователя на кабинет разработчика приложений Яндекс.Store.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.84': '90',

  /**
   * Признак подписки пользователя на партнерский интерфейс дистрибуции.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.85': '91',

  /**
   * Признак подписки пользователя на публичные демо.
   * Sid может использоваться для временных кампаний, промо-акций.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.86': '92',

  /**
   * Признак подписки пользователя на API Яндекс.Островов.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.90': '96',

  /**
   * Признак подписки пользователя на Почтовый офис.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.91': '97',

  /**
   * Признак подписки пользователя на личный кабинет Яндекс.Денег.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.92': '99',

  /**
   * Бинарный ключ, которым шифруются данные Браузера (история, пароли и т. д.).
   * Требует гранта ЧЯ.
   */
  'account.browser_key': '101',

  /**
   * Признак того, что данные пользователя были перенесены с Народа и Видео на Яндекс.Диск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.cloud.is_migrant': '103',

  /**
   * Признак подписки пользователя на новое приложение Яндекс.Почты.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp.2014 / subscription.94': '105',

  /**
   * Признак того, что пользователь включил [пароли приложений](https://yandex.ru/support/passport/authorization/app-passwords.html).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'password.web_onlyaccount.enable_app_password': '107',

  /**
   * Признак подписки пользователя на Видео-поиск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.video.search': '108',

  /**
   * Признак того, что пользователь участвовал в [Охоте за ошибками](https://yandex.ru/support/passport/authorization/app-passwords.html).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.bugbounty': '109',

  /**
   * Признак подписки пользователя на Яндекс.Авиабилеты.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.avia': '112',

  /**
   * Признак подписки пользователя на новую мобильну почту для телефонов Android.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp2014.androidphone': '113',

  /**
   * Признак подписки пользователя на новую мобильну почту для планшетов Android.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp2014.androidtablet': '114',

  /**
   * Признак подписки пользователя на новую мобильну почту для iPhone.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp2014.iphone': '115',

  /**
   * Признак подписки пользователя на новую мобильну почту для iPad.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp2014.ipad': '116',

  /**
   * Признак подписки пользователя на новую мобильну почту для iPad-Birdseye.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.mailapp2014.ipadbirdseye': '117',

  /**
   * Признак подписки пользователя на Кинопоиск.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.kinopoisk': '119',

  /**
   * Признак подписки пользователя на Яндекс.Недвижимость.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.realty': '120',

  /**
   * Признак того, что пользователь является агентом на на Яндекс.Недвижимости.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.realty_agent': '121',

  /**
   * Признак владения [Я.кард](https://yandex.ru/support/money/cards/great-cards.html) от Яндекс.Денег.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.money_yacard_holder': '122',

  /**
   * Признак подписки пользователя на [Яндекс.Работу](https://rabota.yandex.ru).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota': '124',

  /**
   * Признак того, что пользователь является работником на сервисе Яндекс.Работа.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota.employee': '125',

  /**
   * Признак того, что пользователь является `синим воротничком` на сервисе Яндекс.Работа.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota.blue_collar': '126',

  /**
   * Признак того, что пользователь является работодателем на сервисе Яндекс.Работа.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota.employer': '127',

  /**
   * Признак пользователя мобильного приложения Яндекс.Работа.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota.mobile_app': '128',

  /**
   * Признак пользователя мобильного сайта Яндекс.Работа.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.rabota.mobile_site': '129',

  /**
   * Признак модератора Яндекс.Недвижимости.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.realty_moderator': '130',

  /**
   * Признак подписки пользователя на Яндекс.Такси.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.taxi': '131',

  /**
   * Признак совместного аккаунта, например - аккаунт таксопарка.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_shared': '132',

  /**
   * Признак того, что пользователю будет показана промо-страница для включения двухфакторной авторизации после принудительной смены пароля.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.show_2fa_promo': '133',

  /**
   * Пользователи iOS-приложения сервиса Яндекс.Недвижимость.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.realty.app.ios': '137',

  /**
   * Пользователи Android-приложения сервиса Яндекс.Недвижимость.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.realty.app.android': '138',

  /**
   * Признак подписки пользователя на Яндекс.Поиск для сайта (ПДС).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.site_search': '139',

  /**
   * Признак подписки и использования Яндекс.Толоки.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.toloka': '142',

  /**
   * Признак подписки пользователя на Яндекс.Аудитории.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   * Требует гранта ЧЯ.
   */
  'account.audience_on': '146',

  /**
   * Признак подписки пользователя на Яндекс.Телефонию.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   * Требует гранта ЧЯ.
   */
  'subscription.telephony': '148',

  /**
   * Признак того, что пользователь однажды был подписан на Яндекс.Музыку и воспользовался пробным периодом.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'subscription.musicpremium': '152',

  /**
   * Признак администратора Яндекс.Коннекта.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_connect_admin': '154',

  /**
   * Признак того, что пользователь принял EULA Яндекс.Денег.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_money_agreement_accepted': '157',

  /**
   * Uid, для которого был создан колонкиш-аккаунт.
   */
  'account.creator_uid': '166',

  /**
   * Список id ненативных (не принадлежащих домену аккаунта) организаций, к которым относится аккаунт.
   */
  'account.external_organization_ids': '168',

  /**
   * Месяц и день рождения пользователя.
   */
  'person.birthday': '1001',

  /**
   * Год рождения пользователя.
   */
  'person.birthyear': '1002',

  /**
   * Признак включенной двухфакторной аутентификации.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.2fa_on': '1003',

  /**
   * Признак наличия у пользователя пароля, обычного или двухфакторного.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.have_password': '1005',

  /**
   * Признак наличия у пользователя секретного вопроса и ответа для восстановления доступа.
   */
  'account.have_hint': '1006',

  /**
   * Фамилия и имя пользователя.
   */
  'person.fio': '1007',

  /**
   * Нормализованный логин пользователя.
   */
  'account.normalized_login': '1008',

  /**
   * Высокоуровневый признак доступности аккаунта, учитывающий свойство account.is_disabled на аккаунте и domain.enabled на домене.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.is_available': '1009',

  /**
   * Признак того, что у пользователя ПДД указано название организации.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.have_organization_name': '1011',

  /**
   * Степень защищенности аккаунта пользователя.
   */
  'account.security_level': '1013',

  /**
   * Признак того, что у пользователя включена двухфакторная аутентификации
   * при помощи [RFC TOTP](https://ru.wikipedia.org/wiki/Time-based_One-time_Password_Algorithm).
   * Атрибут используется только во [внутреннем ЧЯ](https://docs.yandex-team.ru/blackbox/concepts/location#section_internal).
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.rfc_2fa_on': '1014',

  /**
   * Признак того, что у пользователя включена подписка на Яндекс.Плюс.
   * Если признак присутствует, ответ ЧЯ будет содержать данное поле со значением `1`.
   * Если признак отсутствует, поля в ответе не будет.
   */
  'account.have_plus': '1015',

  /**
   * Строка с именем подписки на Кинопоиск.
   */
  'account.kinopoisk_ott_subscription_name': '1016',

  /**
   * Список идентификаторов организаций, которым принадлежит аккаунт.
   */
  'account.connect_organization_ids': '1017',

  /**
   * Timestamp начала использования пробного периода Яндекс.Плюса.
   */
  'account.plus_trial_used_ts': '1018',

  /**
   * Timestamp остановки подписки Плюса.
   */
  'account.plus_subscription_stopped_ts': '1019',

  /**
   * Timestamp конца подписки Плюса.
   */
  'account.plus_subscription_expire_ts': '1020',

  /**
   * Timestamp следующего списания денег на Яндекс.Плюс.
   */
  'account.plus_next_charge_ts': '1021',

  /**
   * Признак детского аккаунта
   */
  'account.is_child': '210',

  /**
   * Информация о контрольном вопросе
   */
  'hint.question.serialized': '25',
} as const;

/**
 * Чтобы получить значения телефонных атрибутов, используйте параметры
 * `getphones=<all|bound>` и `phone_attributes=<тип_атрибута_1>,<тип_атрибута_2>,...`
 * в [запросах к ЧЯ](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format).
 */
export const BLACKBOX_PHONE_ATTRIBUTES = {
  /**
   * Номер телефона.
   * Требует гранта ЧЯ.
   */
  'phone.number': '1',

  /**
   * Время создания записи.
   * Требует гранта ЧЯ.
   */
  'phone.created': '2',

  /**
   * Время привязки телефона к аккаунту.
   * Требует гранта ЧЯ.
   */
  'phone.bound': '3',

  /**
   * Время подтверждения владения номером.
   * Требует гранта ЧЯ.
   */
  'phone.confirmed': '4',

  /**
   * Время подтверждения пользователем владения номером (варианты: approved, conceded, accepted, agreed).
   * Требует гранта ЧЯ.
   */
  'phone.admitted': '5',

  /**
   * Время получения статуса защищённости номера.
   * Требует гранта ЧЯ.
   */
  'phone.secured': '6',

  /**
   * Номер в international формате `(+7 999 111-22-33)`.
   * Требует гранта ЧЯ.
   */
  'phone.formatted_number': '101',

  /**
   * Номер в e164 `(+79991112233)`.
   * Требует гранта ЧЯ.
   */
  'phone.e164_number': '102',

  /**
   * Форматированный маскированный номер `(+7 999 ***‒**‒33)`.
   */
  'phone.masked_formatted_number': '103',

  /**
   * Маскированный номер в e164 `(+7999*****33)`.
   */
  'phone.masked_e164_number': '104',

  /**
   * Булевский флаг: подтвержден ли номер.
   */
  'phone.is_confirmed': '105',

  /**
   * Булевский флаг: привязан ли номер.
   */
  'phone.is_bound': '106',

  /**
   * Булевский флаг: дефолтный ли номер.
   */
  'phone.is_default': '107',

  /**
   * Булевский флаг: защищен ли номер.
   */
  'phone.is_secured': '108',
} as const;

/**
 * Чтобы получить значения почтовых атрибутов, используйте параметры
 * `getemails=all` и `email_attributes=<тип_атрибута_1>,<тип_атрибута_2>,...`
 * в [запросах к ЧЯ](https://docs.yandex-team.ru/blackbox/methods/userinfo#request_format).
 */
export const BLACKBOX_EMAIL_ATTRIBUTES = {
  /**
   * Внешний адрес электронной почты.
   */
  'email.address': '1',

  /**
   * Время создания email'а.
   */
  'email.created': '2',

  /**
   * Время подтверждения email'а.
   */
  'email.confirmed': '3',

  /**
   * Время привязки email'а.
   */
  'email.bound': '4',

  /**
   * Сборщик писем.
   */
  'email.is_rpop': '5',

  /**
   * Запрет использования почтового ящика для восстановления пароля.
   */
  'email.is_unsafe': '6',

  /**
   * Запрет рассылок и нотификаций на
   */
  'email.is_silent': '7',
} as const;

/**
 * TODO: Эти атрибуты не указаны в документации, но используется внутри
 * бэкенда паспорта.
 * Нужно понять нужны ли они и можно ли их использовать и получить для них гранты
 */
export const __TODO_BLACKBOX_ATTRIBUTES = {
  'account.sms_2fa_on': '200',
  'account.magic_link_login_forbidden': '181',
  'account.qr_code_login_forbidden': '182',
  'account.sms_code_login_forbidden': '187',
  'account.has_family_plus': '1022',
  'account.suggest_public_name': '1023',
} as const;
