import { InternalServerErrorException } from '@nestjs/common';
import { BlackboxResult } from '@yandex-int/nest-infra';

type BlackboxStatus = BlackboxResult['status'];

export interface BlackboxExceptionPayload {
  status: BlackboxStatus;
  message: string;
}

export class BlackboxException extends InternalServerErrorException {
  private payload: BlackboxExceptionPayload;

  constructor(blackbox: BlackboxResult | null) {
    super(null, blackbox?.error);

    this.payload = {
      status: blackbox?.status ?? 'INVALID',
      message: blackbox?.error ?? '',
    };
  }

  getPayload() {
    return this.payload;
  }
}
