import type { Response } from 'express';

import { ArgumentsHost, Catch } from '@nestjs/common';
import { PathsConfigService } from '@server/config';
import { LoggerService } from '@server/shared/logger';

import { BlackboxException } from './blackbox.exception';

@Catch(BlackboxException)
export class BlackboxExceptionFilter {
  constructor(private paths: PathsConfigService, private logger: LoggerService) {}

  catch(exception: BlackboxException, host: ArgumentsHost) {
    const ctx = host.switchToHttp();
    const response = ctx.getResponse<Response>();
    const payload = exception.getPayload();

    const isNeedReset = payload.status === 'NEED_RESET';

    if (isNeedReset) {
      return response.redirect(this.paths.passportAuthUpdateUrl);
    }

    const path = ctx.getRequest().originalUrl;

    this.logger.error('BlackBox exception', { name: exception.name, err: payload, path });

    response.redirect(this.paths.passportAuthUrl);
  }
}
